package com.pt5.pthouduan.controller;

import com.pt5.pthouduan.entity.Complain;
import com.pt5.pthouduan.service.ComplainService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.stereotype.Controller;

import java.util.List;

/**
 * <p>
 *  投诉前端控制器
 * </p>
 *
 * 功能：增、删、改、查（按被投诉用户ID）
 *
 * @author ym
 * @since 2025-04-14
 */
@CrossOrigin(origins = {"http://localhost:5173", "http://localhost:3000"})
@Controller
@RequestMapping("/complain")
public class ComplainController {

    @Autowired
    private ComplainService complainService;

    // 创建投诉
    @PostMapping("/create")
    @ResponseBody
    public Complain createComplain(@RequestBody Complain complain) {
        System.out.println("Received complain: " + complain);  // 输出接收到的投诉数据
        return complainService.createComplain(complain);
    }

    // 删除投诉（根据complainid）
    @DeleteMapping("/delete/{complainid}")
    @ResponseBody
    public boolean deleteComplain(@PathVariable Integer complainid) {
        return complainService.deleteComplain(complainid);
    }

    // 更新投诉内容
    @PutMapping("/update")
    @ResponseBody
    public boolean updateComplain(@RequestBody Complain complain) {
        return complainService.updateComplain(complain);
    }

    // 获取某个用户被投诉的所有记录（根据duser）
    @GetMapping("/target/{duser}")
    @ResponseBody
    public List<Complain> getComplainsByTargetUser(@PathVariable Long duser) {
        return complainService.getComplainsByTargetUser(duser);
    }

    // 获取某个用户提交的所有投诉记录（根据puse）
    @GetMapping("/from/{puse}")
    @ResponseBody
    public List<Complain> getComplainsByPostingUser(@PathVariable Long puse) {
        return complainService.getComplainsByPostingUser(puse);
    }

    // 获取所有投诉记录（管理员查看用）
    @GetMapping("/all")
    @ResponseBody
    public List<Complain> getAllComplains() {
        return complainService.getAllComplains();
    }

    // 根据投诉号获取对应的投诉人、被投诉人和种子号
    @GetMapping("/info/{complainid}")
    @ResponseBody
    public Complain getComplainInfo(@PathVariable Integer complainid) {
        return complainService.getComplainById(complainid);
    }
}
