package com.pt5.pthouduan.controller;

import com.pt5.pthouduan.entity.User;
import com.pt5.pthouduan.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.stereotype.Controller;
import org.springframework.web.multipart.MultipartFile;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author ljx
 * @since 2025-04-14
 */
@RestController
@RequestMapping("/user")
public class UserController {
    @Autowired
    private UserService userService;
    private String uploadDir="../var/www/avatars/";  // 配置文件上传目录，例如: /var/www/avatars/

    private String accessPath="../avatars/";

    @PostMapping("/register")
    public Map<String, Object> register(@RequestBody User user,@RequestParam String code,@RequestParam String emailcode) {//code是邀请码,emailcode是验证码
        return userService.register(user,code,emailcode);
    }

    @PostMapping("/login")
    public Map<String, Object> login(@RequestParam String username,
                                     @RequestParam String password) {
        return userService.login(username, password);
    }

    @PostMapping("/calgrade")
    public Map<String, Object> calgrade(@RequestParam String username) {
        return userService.CalGrade(username);
    }

    @PostMapping("/changesex")
    public Map<String, Object> changsex(@RequestParam String username,
                                        @RequestParam String sex) {
        return userService.changesex(username,sex);
    }

    @PostMapping("/changeimage")
    public Map<String, Object> changeimage(@RequestParam String username, @RequestParam String image) {
        Map<String, Object> response = new HashMap<>();
        userService.changeImage(username,image);
        response.put("success", true);
        response.put("message", "头像更改成功");
        return response;
    }

    @PostMapping("/changePassword")
    public Map<String, Object> changePassword(@RequestParam String username,
                                              @RequestParam String oldpassword,
                                              @RequestParam String newpassword) {
        return userService.changePassword(username,oldpassword,newpassword);
    }

    @PostMapping("/sendCode")
    public Map<String, Object> sendCode(@RequestParam String email) {
        return userService.sendCode(email);
    }

    @GetMapping("/Info")
    public Map<String, Object> getuser(@RequestParam String username) {
        return userService.UserInfo(username);
    }

    @PostMapping("/creatUser")
    public Map<String, Object> creatUser(@RequestBody User user) {
        return userService.CreateUser(user);
    }

    @PostMapping("/DeleteUser")
    public Map<String, Object> DeleteUser(@RequestParam String username) {
        return userService.DeleteUser(username);
    }

    @GetMapping("/alluser")
    public Map<String, Object> alluser() {
        return userService.getAllUser();
    }

    @GetMapping("/finduser")
    public Map<String, Object> finduser(@RequestParam String keyword) {
        return userService.findUser(keyword);
    }

    @GetMapping("/getDecoration")
    public Map<String, Object> getDecoration(@RequestParam Long userid) {
        return userService.getDecoration(userid);
    }

    @GetMapping("/getUserid")
    public Map<String, Object> getuserid(@RequestParam String username) {
        return userService.getuserid(username);
    }

    @PostMapping("/uploadimage")
    public ResponseEntity<Map<String, Object>> uploadAvatar(@RequestParam("avatar") MultipartFile file) {
        Map<String, Object> response = new HashMap<>();

        // 1. 验证文件是否为空
        if (file.isEmpty()) {
            response.put("success", false);
            response.put("message", "请选择要上传的文件");
            return ResponseEntity.badRequest().body(response);
        }

        // 2. 验证文件类型
        String contentType = file.getContentType();
        if (!"image/jpeg".equals(contentType) &&
                !"image/png".equals(contentType) &&
                !"image/gif".equals(contentType)) {
            response.put("success", false);
            response.put("message", "只支持JPG/PNG/GIF格式的图片");
            return ResponseEntity.badRequest().body(response);
        }

        // 3. 验证文件大小 (前端已验证，后端再次验证)
        if (file.getSize() > 10 * 1024 * 1024) { // 10MB
            response.put("success", false);
            response.put("message", "图片大小不能超过10MB");
            return ResponseEntity.badRequest().body(response);
        }

        try {
            // 4. 创建上传目录(如果不存在)
            File dir = new File(uploadDir);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            System.out.println(dir.getAbsolutePath());
            // 5. 生成唯一文件名 (日期+UUID+后缀)
            String originalFilename = file.getOriginalFilename();
            String fileExt = originalFilename.substring(originalFilename.lastIndexOf("."));
            String newFilename = new SimpleDateFormat("yyyyMMdd").format(new Date()) +
                    "_" + UUID.randomUUID().toString().replace("-", "") +
                    fileExt.toLowerCase();

            // 6. 保存文件
            Path path = Paths.get(uploadDir, newFilename);
            Files.copy(file.getInputStream(), path);

            // 7. 返回访问URL
            String fileUrl = accessPath + newFilename;

            response.put("success", true);
            response.put("url", fileUrl);
            response.put("message", "头像上传成功");

            return ResponseEntity.ok(response);

        } catch (IOException e) {
            e.printStackTrace();
            response.put("success", false);
            response.put("message", "文件上传失败: " + e.getMessage());
            return ResponseEntity.status(500).body(response);
        }
    }


}
