package com.pt5.pthouduan.mapper;

import com.pt5.pthouduan.entity.Invites;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.pt5.pthouduan.entity.User;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author ljx
 * @since 2025-04-14
 */
@Repository
public interface InvitesMapper extends BaseMapper<Invites> {

    @Select("SELECT * FROM invite WHERE code = #{code}")
    Map<String, Object> selectByCode(String code);

    @Update("UPDATE invite SET isUsed = 1, username = #{username} WHERE code = #{code}")
    int updateInviteByCode(@Param("code") String code, @Param("username") String username);

    @Select("SELECT * FROM invite WHERE (buyername = '' OR buyername IS NULL) LIMIT 1")
    Map<String, Object> selectFirstEmptyBuyername();

    @Update("UPDATE invite SET buyername = #{buyername} WHERE code = #{code}")
    int updatebuyer(@Param("code") String code, @Param("buyername") String buyername);

    @Select("SELECT * FROM invite WHERE buyername = #{username}")
    List<Map<String, Object>> selectInvitesByUsername(@Param("username") String username);
}
