package com.pt5.pthouduan.service;

import com.pt5.pthouduan.entity.ChatInformation;

import java.util.List;

/**
 * <p>
 * 聊天记录服务接口
 * </p>
 *
 * 功能：添加聊天记录、删除聊天记录、查询用户与所有人的聊天、查询两个用户之间的聊天
 *
 * @author ym
 * @since 2025-06-03
 */
public interface ChatInformationService {

    // 创建聊天记录
    ChatInformation createChat(ChatInformation chatInformation);

    // 删除聊天记录
    boolean deleteChatById(Integer informationid);

    // 获取某个用户与所有人的聊天记录
    List<ChatInformation> getChatsByUser(Long userId);

    // 获取两个用户之间的聊天记录
    List<ChatInformation> getChatsBetweenUsers(Long user1, Long user2);
}
