package com.pt5.pthouduan.service.impl;

import com.pt5.pthouduan.entity.ChatInformation;
import com.pt5.pthouduan.mapper.ChatInformationMapper;
import com.pt5.pthouduan.service.ChatInformationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 聊天记录服务实现类
 * </p>
 *
 * 实现了聊天记录的增删查逻辑
 *
 * @author ym
 * @since 2025-06-03
 */
@Service
public class ChatInformationServiceImpl implements ChatInformationService {

    @Autowired
    private ChatInformationMapper chatInformationMapper;

    @Override
    public ChatInformation createChat(ChatInformation chatInformation) {
        chatInformationMapper.insertChat(chatInformation);
        return chatInformation;
    }

    @Override
    public boolean deleteChatById(Integer informationid) {
        return chatInformationMapper.deleteChatById(informationid) > 0;
    }

    @Override
    public List<ChatInformation> getChatsByUser(Long userId) {
        return chatInformationMapper.selectChatsByUser(userId);
    }

    @Override
    public List<ChatInformation> getChatsBetweenUsers(Long user1, Long user2) {
        return chatInformationMapper.selectChatsBetweenUsers(user1, user2);
    }
}
