package com.pt5.pthouduan.controller;

import com.pt5.pthouduan.entity.ChatInformation;
import com.pt5.pthouduan.service.ChatInformationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.stereotype.Controller;

import java.util.List;

/**
 * <p>
 * 聊天记录前端控制器
 * </p>
 *
 * 功能：添加聊天记录、删除聊天记录、查询用户与所有人的聊天、查询两个用户之间的聊天
 *
 * @author 杨蔓
 * @since 2025-06-03
 */
@CrossOrigin(origins = {"http://localhost:5173", "http://localhost:3000"})
@Controller
@RequestMapping("/chat")
public class ChatInformationController {

    @Autowired
    private ChatInformationService chatInformationService;

    // 创建聊天记录
    @PostMapping("/create")
    @ResponseBody
    public ChatInformation createChat(@RequestBody ChatInformation chatInformation) {
        return chatInformationService.createChat(chatInformation);
    }

    // 删除聊天记录（根据信息ID）
    @DeleteMapping("/delete/{informationid}")
    @ResponseBody
    public String deleteChat(@PathVariable Integer informationid) {
        boolean deleted = chatInformationService.deleteChatById(informationid);
        return deleted ? "删除成功" : "删除失败";
    }

    // 获取某个用户与所有人的聊天记录（作为发送者或接收者）
    @GetMapping("/user/{userId}")
    @ResponseBody
    public List<ChatInformation> getChatsByUser(@PathVariable Long userId) {
        return chatInformationService.getChatsByUser(userId);
    }

    // 获取两个用户之间的聊天记录
    @GetMapping("/between")
    @ResponseBody
    public List<ChatInformation> getChatsBetweenUsers(@RequestParam Long user1,
                                                      @RequestParam Long user2) {
        return chatInformationService.getChatsBetweenUsers(user1, user2);
    }
}
