package com.pt5.pthouduan.mapper;

import com.pt5.pthouduan.entity.Torrent;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * <p>
 *  Mapper 接口
 * </p>
 *
 * @author ljx
 * @since 2025-04-14
 */
@Mapper
public interface TorrentMapper extends BaseMapper<Torrent> {
    // 仅保留方法声明，移除所有SQL注解
    List<Torrent> selectByUploaderId(@Param("uploaderId") Long uploaderId);
    List<Torrent> searchByName(@Param("keyword") String keyword);
    List<Torrent> selectTopPopular();
    List<Torrent> getAllTorrents();
    Integer existsByInfoHash(@Param("infoHash") String infoHash);
    void incrementDownloadCount(@Param("id") Long id);
    void save(Torrent entity);
    List<Torrent> selectTorrentsByCategory(Integer category);
    Torrent selectById(@Param("torrentid") Long id);
    List<Torrent> searchByKeyword(String keyword);

    void setFreePromotion();       // 免费下载
    void setDoubleUpload();        // 上传加倍
    void setHalfDownload();        // 下载减半
    void clearPromotion();         // 恢复促销
    Torrent selectByinfohash(@Param("infohash") String infohash);

    List<Torrent> listByCategoryWithFilters(Integer categoryid, Map<String, String> filters, String extendTable);
}
