package com.pt5.pthouduan.ControllerTest;

import com.pt5.pthouduan.controller.TorrentController;
import com.pt5.pthouduan.entity.User;
import com.pt5.pthouduan.service.TorrentService;
import org.apache.tomcat.util.net.openssl.ciphers.Authentication;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

import java.util.HashMap;
import java.util.Map;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.*;
import static org.mockito.Mockito.*;

public class TorrentUploadControllerTest {

    @Mock
    private TorrentService torrentService;

    @InjectMocks
    private TorrentController torrentController;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        setupSecurityContext();
    }

    private void setupSecurityContext() {
        // 设置模拟用户
        User user = new User(1L, "testuser");
        Authentication authentication = mock(Authentication.class);
    }

    @Test
    void uploadTorrent_Success() throws Exception {
        // 准备测试数据
        MockMultipartFile mockFile = new MockMultipartFile(
                "file", "test.torrent", "application/x-bittorrent", "mock torrent data".getBytes()
        );

        // 准备参数
        String title = "Test Torrent";
        String description = "Test Description";
        Integer categoryId = 1;
        String dpi = "1080";
        String caption = "Test Caption";
        String region = "CN";
        Integer year = 2023;
        String genre = "Action";

        // 准备预期的extraParams
        Map<String, String> expectedExtraParams = new HashMap<>();
        expectedExtraParams.put("dpi", dpi);
        expectedExtraParams.put("caption", caption);
        expectedExtraParams.put("region", region);
        expectedExtraParams.put("year", year.toString());
        expectedExtraParams.put("genre", genre);

        // 模拟Service行为
        when(torrentService.uploadWithCategory(
                any(MultipartFile.class), anyString(), anyString(),
                anyInt(), any(User.class), anyMap())
        ).thenReturn(ResponseEntity.ok().build());

        // 执行测试
        ResponseEntity<?> response = torrentController.uploadTorrent(
                mockFile, title, description, categoryId,
                dpi, caption,
                region, year, genre,
                null, null, null, null, null, null, null, null, null, null
        );

        // 验证结果
        assertEquals(HttpStatus.OK, response.getStatusCode());

        // 使用ArgumentCaptor捕获参数
        ArgumentCaptor<Map<String, String>> captor = ArgumentCaptor.forClass(Map.class);
        verify(torrentService).uploadWithCategory(
                eq(mockFile), eq(title), eq(description),
                eq(categoryId), any(User.class), captor.capture()
        );

        // 验证Map内容
        Map<String, String> actualParams = captor.getValue();
        assertEquals(expectedExtraParams, actualParams);
    }

    @Test
    void uploadTorrent_WithAllOptionalParams() throws Exception {
        // 准备测试数据
        MockMultipartFile mockFile = new MockMultipartFile(
                "file", "test.torrent", "application/x-bittorrent", "mock torrent data".getBytes()
        );

        // 准备所有可能的参数
        String title = "Complete Torrent";
        String description = "Complete Description";
        Integer categoryId = 2;

        // 准备所有可选参数
        String dpi = "4K";
        String caption = "Complete Caption";
        String region = "US";
        Integer year = 2022;
        String genre = "Sci-Fi";
        String format = "MP4";
        String resolution = "2160p";
        String codecFormat = "H.265";
        String platform = "PC";
        String language = "English";
        String eventType = "Championship";
        String dataType = "RAW";
        String source = "Blu-ray";
        String style = "Rock";
        Boolean isMainland = false;

        // 准备预期的extraParams
        Map<String, String> expectedExtraParams = new HashMap<>();
        expectedExtraParams.put("dpi", dpi);
        expectedExtraParams.put("caption", caption);
        expectedExtraParams.put("region", region);
        expectedExtraParams.put("year", year.toString());
        expectedExtraParams.put("genre", genre);
        expectedExtraParams.put("format", format);
        expectedExtraParams.put("resolution", resolution);
        expectedExtraParams.put("codecFormat", codecFormat);
        expectedExtraParams.put("platform", platform);
        expectedExtraParams.put("language", language);
        expectedExtraParams.put("eventType", eventType);
        expectedExtraParams.put("dataType", dataType);
        expectedExtraParams.put("source", source);
        expectedExtraParams.put("style", style);
        expectedExtraParams.put("isMainland", isMainland.toString());

        // 模拟Service行为
        when(torrentService.uploadWithCategory(
                any(MultipartFile.class), anyString(), anyString(),
                anyInt(), any(User.class), anyMap())
        ).thenReturn(ResponseEntity.ok().build());

        // 执行测试
        ResponseEntity<?> response = torrentController.uploadTorrent(
                mockFile, title, description, categoryId,
                dpi, caption,
                region, year, genre,
                format, resolution, codecFormat,
                platform, language, eventType,
                dataType, source, style, isMainland
        );

        // 验证结果
        assertEquals(HttpStatus.OK, response.getStatusCode());

        // 验证参数传递
        ArgumentCaptor<Map<String, String>> captor = ArgumentCaptor.forClass(Map.class);
        verify(torrentService).uploadWithCategory(
                eq(mockFile), eq(title), eq(description),
                eq(categoryId), any(User.class), captor.capture()
        );

        // 验证所有参数都被正确传递
        Map<String, String> actualParams = captor.getValue();
        assertEquals(expectedExtraParams, actualParams);
    }

    @Test
    void uploadTorrent_WithNullOptionalParams() throws Exception {
        // 准备测试数据
        MockMultipartFile mockFile = new MockMultipartFile(
                "file", "test.torrent", "application/x-bittorrent", "mock torrent data".getBytes()
        );

        String title = "Minimal Torrent";
        String description = "Minimal Description";
        Integer categoryId = 3;

        // 模拟Service行为
        when(torrentService.uploadWithCategory(
                any(MultipartFile.class), anyString(), anyString(),
                anyInt(), any(User.class), anyMap())
        ).thenReturn(ResponseEntity.ok().build());

        // 执行测试 - 只传必填参数，可选参数都为null
        ResponseEntity<?> response = torrentController.uploadTorrent(
                mockFile, title, description, categoryId,
                null, null, null, null, null,
                null, null, null, null, null,
                null, null, null, null, null
        );

        // 验证结果
        assertEquals(HttpStatus.OK, response.getStatusCode());

        // 验证参数传递
        ArgumentCaptor<Map<String, String>> captor = ArgumentCaptor.forClass(Map.class);
        verify(torrentService).uploadWithCategory(
                eq(mockFile), eq(title), eq(description),
                eq(categoryId), any(User.class), captor.capture()
        );

        // 验证extraParams为空
        Map<String, String> actualParams = captor.getValue();
        assertTrue(actualParams.isEmpty());
    }

    @Test
    void uploadTorrent_ServiceThrowsException() throws Exception {
        // 准备测试数据
        MockMultipartFile mockFile = new MockMultipartFile(
                "file", "test.torrent", "application/x-bittorrent", "mock torrent data".getBytes()
        );

        String title = "Failing Torrent";
        String description = "Failing Description";
        Integer categoryId = 4;

        // 模拟Service抛出异常
        when(torrentService.uploadWithCategory(
                any(MultipartFile.class), anyString(), anyString(),
                anyInt(), any(User.class), anyMap())
        ).thenThrow(new RuntimeException("Upload failed"));

        // 执行测试
        ResponseEntity<?> response = torrentController.uploadTorrent(
                mockFile, title, description, categoryId,
                null, null, null, null, null,
                null, null, null, null, null,
                null, null, null, null, null
        );

        // 验证结果
        assertEquals(HttpStatus.BAD_REQUEST, response.getStatusCode());
        assertTrue(response.getBody().toString().contains("Upload failed"));
    }

}