package com.pt5.pthouduan.ControllerTest;

import com.pt5.pthouduan.controller.UserController;
import com.pt5.pthouduan.entity.User;
import com.pt5.pthouduan.service.UserService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.ResponseEntity;

import java.util.HashMap;
import java.util.Map;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.*;
import static org.mockito.Mockito.*;

class UserControllerTest {

    @Mock
    private UserService userService;

    @InjectMocks
    private UserController userController;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
    }

    // 注册测试
    @Test
    void register_ShouldCallServiceWithCorrectParameters() {
        // 准备测试数据
        User testUser = new User(1L,"");
        testUser.setUsername("testUser");
        String testCode = "123456";
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", true);
        expectedResponse.put("message", "注册成功");

        // 模拟服务行为
        when(userService.register(any(User.class), anyString())).thenReturn(expectedResponse);

        // 执行测试
        Map<String, Object> actualResponse = userController.register(testUser, testCode);

        // 验证行为
        verify(userService, times(1)).register(testUser, testCode);

        // 验证结果
        assertEquals(expectedResponse, actualResponse);
    }

    // 登录测试
    @Test
    void login_ShouldReturnSuccessWhenCredentialsAreValid() {
        // 准备测试数据
        String username = "testUser";
        String password = "correctPassword";
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", true);
        expectedResponse.put("token", "sampleToken");

        // 模拟服务行为
        when(userService.login(eq(username), eq(password))).thenReturn(expectedResponse);

        // 执行测试
        Map<String, Object> actualResponse = userController.login(username, password);

        // 验证行为
        verify(userService, times(1)).login(username, password);

        // 验证结果
        assertEquals(expectedResponse, actualResponse);
        assertTrue((Boolean) actualResponse.get("success"));
        assertNotNull(actualResponse.get("token"));
    }

    // 计算等级测试
    @Test
    void calgrade_ShouldReturnUserGrade() {
        // 准备测试数据
        String username = "testUser";
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("grade", 5);
        expectedResponse.put("exp", 1200);

        // 模拟服务行为
        when(userService.CalGrade(eq(username))).thenReturn(expectedResponse);

        // 执行测试
        Map<String, Object> actualResponse = userController.calgrade(username);

        // 验证行为
        verify(userService, times(1)).CalGrade(username);

        // 验证结果
        assertEquals(5, actualResponse.get("grade"));
        assertEquals(1200, actualResponse.get("exp"));
    }

    // 修改性别测试
    @Test
    void changesex_ShouldUpdateUserSex() {
        // 准备测试数据
        String username = "testUser";
        String newSex = "male";
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", true);
        expectedResponse.put("message", "性别更新成功");

        // 模拟服务行为
        when(userService.changesex(eq(username), eq(newSex))).thenReturn(expectedResponse);

        // 执行测试
        Map<String, Object> actualResponse = userController.changsex(username, newSex);

        // 验证行为
        verify(userService, times(1)).changesex(username, newSex);

        // 验证结果
        assertTrue((Boolean) actualResponse.get("success"));
        assertEquals("性别更新成功", actualResponse.get("message"));
    }

    // 修改头像测试
    @Test
    void changeimage_ShouldUpdateUserImage() {
        // 准备测试数据
        String username = "testUser";
        String newImage = "newImageUrl";
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", true);
        expectedResponse.put("message", "头像更新成功");

        // 模拟服务行为
        when(userService.changeImage(eq(username), eq(newImage))).thenReturn(expectedResponse);

        // 执行测试
        Map<String, Object> actualResponse = userController.changeimage(username, newImage);

        // 验证行为
        verify(userService, times(1)).changeImage(username, newImage);

        // 验证结果
        assertTrue((Boolean) actualResponse.get("success"));
        assertEquals("头像更新成功", actualResponse.get("message"));
    }

    // 修改密码测试
    @Test
    void changePassword_ShouldReturnSuccessWhenOldPasswordIsCorrect() {
        // 准备测试数据
        String username = "testUser";
        String oldPassword = "correctOldPassword";
        String newPassword = "newSecurePassword";
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", true);
        expectedResponse.put("message", "密码修改成功");

        // 模拟服务行为
        when(userService.changePassword(eq(username), eq(oldPassword), eq(newPassword)))
                .thenReturn(expectedResponse);

        // 执行测试
        Map<String, Object> actualResponse = userController.changePassword(username, oldPassword, newPassword);

        // 验证行为
        verify(userService, times(1)).changePassword(username, oldPassword, newPassword);

        // 验证结果
        assertTrue((Boolean) actualResponse.get("success"));
        assertEquals("密码修改成功", actualResponse.get("message"));
    }

    // 获取用户信息测试
    @Test
    void getUserInfo_ShouldReturnUserInfo() {
        // 准备测试数据
        String username = "testUser";
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("username", username);
        expectedResponse.put("email", "test@example.com");

        // 模拟服务行为
        when(userService.login(eq(username), eq(""))).thenReturn(expectedResponse);

        // 执行测试
        Map<String, Object> actualResponse = userController.getUserInfo(username);

        // 验证行为
        verify(userService, times(1)).login(username, "");

        // 验证结果
        assertEquals(username, actualResponse.get("username"));
        assertEquals("test@example.com", actualResponse.get("email"));
    }

    // 异常情况测试
    @Test
    void login_ShouldReturnFailureWhenCredentialsAreInvalid() {
        // 准备测试数据
        String username = "testUser";
        String wrongPassword = "wrongPassword";
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", false);
        expectedResponse.put("message", "用户名或密码错误");

        // 模拟服务行为
        when(userService.login(eq(username), eq(wrongPassword))).thenReturn(expectedResponse);

        // 执行测试
        Map<String, Object> actualResponse = userController.login(username, wrongPassword);

        // 验证结果
        assertFalse((Boolean) actualResponse.get("success"));
        assertEquals("用户名或密码错误", actualResponse.get("message"));
    }
}
