package com.pt5.pthouduan.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.pt5.pthouduan.entity.ChatInformation;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 聊天记录 Mapper 接口
 * </p>
 *
 * 功能：添加、删除、查询（按用户ID、用户对）
 *
 * @author ym
 * @since 2025-06-03
 */
@Mapper
public interface ChatInformationMapper extends BaseMapper<ChatInformation> {

    // 创建聊天记录
    void insertChat(ChatInformation chatInformation);

    // 根据信息ID删除聊天记录
    int deleteChatById(@Param("informationid") Integer informationid);

    // 获取某个用户参与的所有聊天记录（作为发送方或接收方）
    List<ChatInformation> selectChatsByUser(@Param("userId") Long userId);

    // 获取两个用户之间的聊天记录（无论谁是发送方或接收方）
    List<ChatInformation> selectChatsBetweenUsers(@Param("user1") Long user1, @Param("user2") Long user2);
}
