package com.pt5.pthouduan.service;

import com.pt5.pthouduan.entity.Activity;

import java.util.List;

/**
 * <p>
 * 活动服务接口
 * </p>
 *
 * 功能：增、删、改、查（按是否显示状态）
 * </p>
 *
 * @author ym
 * @since 2025-05-16
 */
public interface ActivityService {

    // 根据 is_show 状态查询活动列表（0：显示，1：隐藏等）
    List<Activity> findByIsShow(Integer isShow);

    // 创建活动
    boolean save(Activity activity);

    // 根据ID删除活动
    boolean removeById(Integer activityid);

    // 根据ID更新活动
    boolean updateById(Activity activity);

    // 根据ID获取活动
    Activity getById(Integer activityid);

    // 新增：获取所有活动（不分是否显示）
    List<Activity> list();

    //根据题目获得公告
    List<Activity> searchByTitle(String title);
}
