package com.pt5.pthouduan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.pt5.pthouduan.entity.Activity;
import com.pt5.pthouduan.mapper.ActivityMapper;
import com.pt5.pthouduan.service.ActivityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 活动服务实现类
 * </p>
 *
 * 实现了活动的增删改查逻辑
 * </p>
 *
 * @author ym
 * @since 2025-05-16
 */
@Service
public class ActivityServiceImpl implements ActivityService {

    @Autowired
    private ActivityMapper activityMapper;

    @Override
    public List<Activity> findByIsShow(Integer isShow) {
        return activityMapper.selectByIsShow(isShow);
    }

    @Override
    public boolean save(Activity activity) {
        return activityMapper.insert(activity) > 0;
    }

    @Override
    public boolean removeById(Integer activityid) {
        return activityMapper.deleteById(activityid) > 0;
    }

    @Override
    public boolean updateById(Activity activity) {
        return activityMapper.updateById(activity) > 0;
    }

    @Override
    public Activity getById(Integer activityid) {
        return activityMapper.selectById(activityid);
    }

    // 新增：查询所有活动（不分是否显示）
    @Override
    public List<Activity> list() {
        return activityMapper.selectList(null);
    }

    @Override
    public List<Activity> searchByTitle(String title) {
        QueryWrapper<Activity> queryWrapper = new QueryWrapper<>();
        // 模糊匹配 title 字段
        queryWrapper.like("title", title);
        return activityMapper.selectList(queryWrapper);
    }
}
