package com.pt5.pthouduan.service.impl;

import com.pt5.pthouduan.entity.Post;
import com.pt5.pthouduan.mapper.PostMapper;
import com.pt5.pthouduan.service.PostService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 *  帖子服务实现类
 * </p>
 * 提供帖子增删改查、点赞、置顶等功能的业务实现
 *
 * @author 杨蔓
 * @since 2025-04-14
 */
@Service
public class PostServiceImpl implements PostService {

    @Autowired
    private PostMapper postMapper;

    @Override
    public Post createPost(Post post) {
        postMapper.save(post);
        return post;
    }

    @Override
    public boolean deletePost(Integer postId) {
        return postMapper.deleteByPostid(postId) > 0;
    }

    @Override
    public boolean updatePost(Post post) {
        return postMapper.updatePost(post) > 0;
    }

    @Override
    public List<Post> searchPostsByKeyword(String keyword) {
        return postMapper.searchByKeyword(keyword);
    }

    @Override
    public boolean incrementLikes(Integer postId) {
        return postMapper.incrementLikes(postId) >= 0;
    }

    @Override
    public boolean decrementLikes(Integer postId) {
        return postMapper.decrementLikes(postId) >= 0;
    }

    @Override
    public boolean setPinnedStatus(Integer postId, boolean isPinned) {
        return postMapper.updatePinnedStatus(postId, isPinned) > 0;
    }

    @Override
    public List<Post> findByUserid(Long userId) {
        return postMapper.findByUserid(userId);
    }

    @Override
    public List<Post> findPinnedPosts() {
        return postMapper.findPinnedPosts();
    }

    @Override
    public List<Post> getAllPostsSorted() {
        return postMapper.selectAllSorted();
    }

    /** ✅ 补充：根据帖子 ID 获取帖子对象 */
    @Override
    public Post getById(Integer postId) {
        return postMapper.selectById(postId);
    }
}
