package com.pt5.pthouduan.ControllerTest;

import com.pt5.pthouduan.controller.TorrentController;
import com.pt5.pthouduan.mapper.TorrentMapper;
import com.pt5.pthouduan.mapper.UserMapper;
import com.pt5.pthouduan.service.TorrentService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import static org.hamcrest.Matchers.containsString;
import static org.mockito.ArgumentMatchers.anyLong;
import static org.mockito.Mockito.*;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

class TorrentApplyPromotionsControllerTest {

    @Mock
    private UserMapper userMapper;

    @Mock
    private TorrentService torrentService;

    @Mock
    private TorrentMapper torrentMapper;  // Mock TorrentMapper

    @InjectMocks
    private TorrentController torrentController;

    private MockMvc mockMvc;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(torrentController).build();
    }

    @Test
    void applyPromotions_WithPermission_ShouldReturnSuccess() throws Exception {
        // Arrange
        Long userid = 1L;
        Long torrentId = 101L;
        Long helpedId = 2L;

        // 模拟用户有权限(返回1表示有权限)
        when(userMapper.getpermissionByUserid(userid)).thenReturn(1);

        // 模拟服务层调用成功
        doNothing().when(torrentService).addcredit(anyLong(), anyLong(), anyInt());
        doNothing().when(torrentService).deducecredit(anyLong(), anyLong(), anyInt());

        // 模拟 TorrentMapper 方法调用
        //when(torrentMapper.setFreePromotion()).thenReturn(1);  // 关键：Mock torrentMapper

        // Act & Assert
        mockMvc.perform(post("/torrent/applyPromotions")
                        .param("userid", userid.toString())
                        .param("torrentid", torrentId.toString())
                        .param("helpedid", helpedId.toString()))
                .andExpect(status().isOk())  // 验证状态码
                .andExpect(content().string(containsString("success")));  // 验证响应内容
    }


    @Test
    void applyPromotions_WithoutParameters_ShouldReturnBadRequest() throws Exception {
        // Act & Assert
        mockMvc.perform(post("/torrent/applyPromotions"))
                .andExpect(status().isBadRequest());  // 验证状态码
    }
}