package com.pt5.pthouduan.ControllerTest;


import com.pt5.pthouduan.controller.TorrentController;
import com.pt5.pthouduan.service.TorrentService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import static org.mockito.ArgumentMatchers.anyLong;
import static org.mockito.ArgumentMatchers.anyInt;
import static org.mockito.Mockito.*;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

class TorrentDeduceCreditControllerTest {

    @Mock
    private TorrentService torrentService;

    @InjectMocks
    private TorrentController torrentController;

    private MockMvc mockMvc;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(torrentController).build();
    }

    @Test
    void deduceCredit_WithValidParameters_ShouldReturnSuccess() throws Exception {
        // Arrange
        Long manageid = 1L;
        Long userid = 2L;
        Integer credit = 10;

        // 模拟服务层调用成功
        doNothing().when(torrentService).deducecredit(manageid, userid, credit);

        // Act & Assert
        mockMvc.perform(post("/torrent/deducecredit")
                        .param("manageid", manageid.toString())
                        .param("userid", userid.toString())
                        .param("credit", credit.toString()))
                .andExpect(status().isOk())
                .andExpect(content().string(credit.toString()));

        // 验证服务层方法被调用
        verify(torrentService, times(1)).deducecredit(manageid, userid, credit);
    }

    @Test
    void deduceCredit_WhenServiceThrowsException_ShouldReturnServerError() throws Exception {
        // Arrange
        Long manageid = 1L;
        Long userid = 2L;
        Integer credit = 10;

        // 模拟服务层抛出异常
        doThrow(new RuntimeException("Database error")).when(torrentService).deducecredit(manageid, userid, credit);

        // Act & Assert
        mockMvc.perform(post("/torrent/deducecredit")
                        .param("manageid", manageid.toString())
                        .param("userid", userid.toString())
                        .param("credit", credit.toString()))
                .andExpect(status().isInternalServerError())
                .andExpect(jsonPath("$.success").value(false))
                .andExpect(jsonPath("$.message").value("服务器错误: Database error"));

        // 验证服务层方法被调用
        verify(torrentService, times(1)).deducecredit(manageid, userid, credit);
    }

    @Test
    void deduceCredit_WithoutParameters_ShouldReturnBadRequest() throws Exception {
        // Act & Assert
        mockMvc.perform(post("/torrent/deducecredit"))
                .andExpect(status().isBadRequest());
    }
}
