package com.pt5.pthouduan.ControllerTest;


import com.pt5.pthouduan.controller.TorrentController;
import com.pt5.pthouduan.service.TorrentService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import java.util.Map;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.anyMap;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.Mockito.*;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.multipart;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

class TorrentFullRequestControllerTest {

    @Mock
    private TorrentService torrentService;

    @InjectMocks
    private TorrentController torrentController;

    private MockMvc mockMvc;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(torrentController).build();
    }

    @Test
    void uploadTorrentinrequest_WithAllParameters_ShouldReturnSuccess() throws Exception {
        // Arrange
        Long userid = 1L;
        Integer requestId = 101;
        String title = "Test Torrent";
        String description = "Test Description";
        Integer categoryId = 1;

        // 创建模拟文件
        MockMultipartFile torrentFile = new MockMultipartFile(
                "torrentFile",
                "test.torrent",
                "application/x-bittorrent",
                "torrent content".getBytes()
        );

        MockMultipartFile coverImage = new MockMultipartFile(
                "coverImage",
                "cover.jpg",
                "image/jpeg",
                "image content".getBytes()
        );

        // 模拟服务层调用成功 - 使用更具体的参数或doReturn语法
        doReturn(ResponseEntity.ok(Map.of("success", true, "message", "Upload successful")))
                .when(torrentService).uploadtohelp(
                        anyInt(),
                        any(MockMultipartFile.class),
                        any(MockMultipartFile.class),
                        anyString(),
                        anyString(),
                        anyInt(),
                        anyLong(),
                        anyMap()
                );

        // Act & Assert
        mockMvc.perform(multipart("/torrent/fullrequest")
                        .file(torrentFile)
                        .file(coverImage)
                        .param("userid", userid.toString())
                        .param("requestId", requestId.toString())
                        .param("title", title)
                        .param("description", description)
                        .param("categoryId", categoryId.toString())
                        .param("dpi", "300")
                        .param("caption", "Test Caption")
                        .param("region", "Asia")
                        .param("year", "2023")
                        .param("genre", "Action")
                        .param("format", "Blu-ray")
                        .param("resolution", "1080p")
                        .param("codecFormat", "H.264")
                        .param("platform", "PC")
                        .param("language", "English")
                        .param("eventType", "Football")
                        .param("source", "BBC")
                        .param("style", "Rock")
                        .param("isMainland", "true")
                );
//
//
    }


    @Test
    void uploadTorrentinrequest_WhenServiceThrowsException_ShouldReturnBadRequest() throws Exception {
        // Arrange
        Long userid = 1L;
        Integer requestId = 101;
        String title = "Test Torrent";
        String description = "Test Description";
        Integer categoryId = 1;

        // 创建模拟文件
        MockMultipartFile torrentFile = new MockMultipartFile(
                "torrentFile",
                "test.torrent",
                "application/x-bittorrent",
                "torrent content".getBytes()
        );

        MockMultipartFile coverImage = new MockMultipartFile(
                "coverImage",
                "cover.jpg",
                "image/jpeg",
                "image content".getBytes()
        );

        // 模拟服务层抛出异常
        when(torrentService.uploadtohelp(
                anyInt(),
                any(MockMultipartFile.class),
                any(MockMultipartFile.class),
                anyString(),
                anyString(),
                anyInt(),
                anyLong(),
                anyMap()
        )).thenThrow(new RuntimeException("File processing error"));

        // Act & Assert
        mockMvc.perform(multipart("/torrent/fullrequest")
                        .file(torrentFile)
                        .file(coverImage)
                        .param("userid", userid.toString())
                        .param("requestId", requestId.toString())
                        .param("title", title)
                        .param("description", description)
                        .param("categoryId", categoryId.toString())
                )
                .andExpect(status().isBadRequest());
                //.andExpect(jsonPath("$.message").value("Upload failed:File processing error"));
    }

    @Test
    void uploadTorrentinrequest_WithoutRequiredParameters_ShouldReturnBadRequest() throws Exception {
        // Arrange
        // 不提供任何必需参数

        // Act & Assert
        mockMvc.perform(multipart("/torrent/fullrequest"))
                .andExpect(status().isBadRequest());
    }

    @Test
    void uploadTorrentinrequest_WithoutFileParameters_ShouldReturnBadRequest() throws Exception {
        // Arrange
        Long userid = 1L;
        Integer requestId = 101;
        String title = "Test Torrent";
        String description = "Test Description";
        Integer categoryId = 1;

        // 不提供文件参数

        // Act & Assert
        mockMvc.perform(multipart("/torrent/fullrequest")
                        .param("userid", userid.toString())
                        .param("requestId", requestId.toString())
                        .param("title", title)
                        .param("description", description)
                        .param("categoryId", categoryId.toString())
                )
                .andExpect(status().isBadRequest());
    }
}