package com.pt5.pthouduan.ControllerTest;

import com.pt5.pthouduan.controller.TorrentController;
import com.pt5.pthouduan.entity.Torrent;
import com.pt5.pthouduan.service.TorrentService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

class TorrentListByCategoryControllerTest {

    @Mock
    private TorrentService torrentService;

    @InjectMocks
    private TorrentController torrentController;

    private MockMvc mockMvc;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(torrentController).build();
    }

    @Test
    void getTorrentsByCategory_WithCategoryId_ShouldReturnFilteredTorrents() throws Exception {
        // Arrange
        Integer categoryid = 1;
        Torrent torrent1 = new Torrent();
        Torrent torrent2 = new Torrent();
        List<Torrent> torrents = Arrays.asList(torrent1, torrent2);

        when(torrentService.getTorrentsByCategory(categoryid)).thenReturn(torrents);

        // Act & Assert
        mockMvc.perform(get("/torrent/listByCategory")
                        .param("categoryid", categoryid.toString()))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$").isArray())
                .andExpect(jsonPath("$.length()").value(2));
    }

    @Test
    void getTorrentsByCategory_WithoutCategoryId_ShouldReturnAllTorrents() throws Exception {
        // Arrange
        Torrent torrent1 = new Torrent();
        Torrent torrent2 = new Torrent();
        List<Torrent> torrents = Arrays.asList(torrent1, torrent2);

        when(torrentService.getAllTorrents()).thenReturn(torrents);

        // Act & Assert
        mockMvc.perform(get("/torrent/listByCategory"))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$").isArray())
                .andExpect(jsonPath("$.length()").value(2));
    }

    @Test
    void getTorrentsByCategory_WithNonExistingCategory_ShouldReturnEmptyList() throws Exception {
        // Arrange
        Integer categoryid = 999;
        when(torrentService.getTorrentsByCategory(categoryid)).thenReturn(Collections.emptyList());

        // Act & Assert
        mockMvc.perform(get("/torrent/listByCategory")
                        .param("categoryid", categoryid.toString()))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$").isArray())
                .andExpect(jsonPath("$.length()").value(0));
    }
}