package com.pt5.pthouduan.ControllerTest;


import com.pt5.pthouduan.controller.TorrentController;
import com.pt5.pthouduan.entity.Torrent;
import com.pt5.pthouduan.service.TorrentService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

class TorrentSearchControllerTest {

    @Mock
    private TorrentService torrentService;

    @InjectMocks
    private TorrentController torrentController;

    private MockMvc mockMvc;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(torrentController).build();
    }

    @Test
    void searchTorrents_WithKeyword_ShouldReturnMatchingTorrents() throws Exception {
        // Arrange
        String keyword = "test";
        Torrent torrent1 = new Torrent();
        Torrent torrent2 = new Torrent();
        List<Torrent> torrents = Arrays.asList(torrent1, torrent2);

        when(torrentService.searchByKeyword(keyword)).thenReturn(torrents);

        // Act & Assert
        mockMvc.perform(get("/torrent/search")
                        .param("keyword", keyword))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$").isArray())
                .andExpect(jsonPath("$.length()").value(2));
    }

    @Test
    void searchTorrents_WithEmptyKeyword_ShouldReturnEmptyList() throws Exception {
        // Arrange
        String keyword = "";
        when(torrentService.searchByKeyword(keyword)).thenReturn(Collections.emptyList());

        // Act & Assert
        mockMvc.perform(get("/torrent/search")
                        .param("keyword", keyword))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$").isArray())
                .andExpect(jsonPath("$.length()").value(0));
    }

    @Test
    void searchTorrents_WithNoMatchingTorrents_ShouldReturnEmptyList() throws Exception {
        // Arrange
        String keyword = "nonexistent";
        when(torrentService.searchByKeyword(keyword)).thenReturn(Collections.emptyList());

        // Act & Assert
        mockMvc.perform(get("/torrent/search")
                        .param("keyword", keyword))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$").isArray())
                .andExpect(jsonPath("$.length()").value(0));
    }

    @Test
    void searchTorrents_WithoutKeywordParameter_ShouldReturnBadRequest() throws Exception {
        // Act & Assert
        mockMvc.perform(get("/torrent/search"))
                .andExpect(status().isBadRequest());
    }
}