package com.pt5.pthouduan.ControllerTest;

import com.pt5.pthouduan.controller.TorrentController;
import com.pt5.pthouduan.entity.PeerInfo;
import com.pt5.pthouduan.service.TorrentService;
import com.pt5.pthouduan.service.impl.PeerService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.jsonPath;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;
//static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

class TorrentSeederControllerTest {

    @Mock
    private TorrentService torrentService;

    @Mock
    private PeerService peerService;


    @InjectMocks
    private TorrentController torrentController;

    private MockMvc mockMvc;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(torrentController).build();
    }

    @Test
    void getSeedersByInfoHash_ShouldReturnPeers() throws Exception {
        // Arrange
        String infoHash = "ABC123";
        PeerInfo peer1 = new PeerInfo();
        PeerInfo peer2 = new PeerInfo();
        List<PeerInfo> peers = Arrays.asList(peer1, peer2);

        // 假设torrentService有一个方法返回PeerInfo列表
        // 这里需要根据实际torrentService的API进行调整
        when(peerService.getSeedersByInfoHash(infoHash)).thenReturn(peers);

        // Act & Assert
        mockMvc.perform(get("/torrent/{infoHash}/seeders", infoHash))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$").isArray())
                .andExpect(jsonPath("$.length()").value(2));
    }

    @Test
    void getSeedersByInfoHash_ShouldReturnEmptyListWhenNoPeers() throws Exception {
        // Arrange
        String infoHash = "ABC123";

        // 假设torrentService有一个方法返回空列表
        when(peerService.getSeedersByInfoHash(infoHash)).thenReturn(Collections.emptyList());

        // Act & Assert
        mockMvc.perform(get("/torrent/{infoHash}/seeders", infoHash))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$").isArray())
                .andExpect(jsonPath("$.length()").value(0));
    }
}