package com.pt5.pthouduan.ControllerTest;


import com.pt5.pthouduan.controller.TrafficController;
import com.pt5.pthouduan.entity.UserTrafficStat;
import com.pt5.pthouduan.mapper.UserTrafficMapper;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import java.time.LocalDate;

import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

class TrafficControllerTest {

    private MockMvc mockMvc;

    @Mock
    private UserTrafficMapper userTrafficMapper; // 模拟 Mapper

    @InjectMocks
    private TrafficController trafficController; // 注入 Controller

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this); // 初始化 Mock
        mockMvc = MockMvcBuilders.standaloneSetup(trafficController).build(); // 构建 MockMvc
    }

    @Test
    void getUserTrafficStats_shouldReturnStats_whenPasskeyAndDatesAreValid() throws Exception {
        // 准备测试数据
        String passkey = "test-passkey";
        LocalDate startDate = LocalDate.of(2023, 1, 1);
        LocalDate endDate = LocalDate.of(2023, 1, 31);

        UserTrafficStat mockStats = new UserTrafficStat();
        mockStats.setTotalUploaded(1024L);
        mockStats.setTotalDownloaded(2048L);

        // 模拟 Mapper 行为
        when(userTrafficMapper.getUserTrafficStats(anyString(), any(LocalDate.class), any(LocalDate.class)))
                .thenReturn(mockStats);

        // 发起 GET 请求并验证响应
        mockMvc.perform(get("/api/traffic/user-stats")
                        .param("passkey", passkey)
                        .param("startDate", startDate.toString())
                        .param("endDate", endDate.toString())
                        .contentType(MediaType.APPLICATION_JSON))
                .andExpect(status().isOk()); // 预期 HTTP 200
    }

    @Test
    void getUserTrafficStats_shouldReturn400_whenPasskeyIsMissing() throws Exception {
        // 不传 passkey，预期返回 400 Bad Request
        mockMvc.perform(get("/api/traffic/user-stats")
                        .param("startDate", "2023-01-01")
                        .param("endDate", "2023-01-31")
                        .contentType(MediaType.APPLICATION_JSON))
                .andExpect(status().isBadRequest());
    }

    @Test
    void getUserTrafficStats_shouldReturn400_whenDatesAreInvalid() throws Exception {
        // 传入无效日期格式，预期返回 400 Bad Request
        mockMvc.perform(get("/api/traffic/user-stats")
                        .param("passkey", "test-passkey")
                        .param("startDate", "2023-01-01-invalid")
                        .param("endDate", "2023-01-31")
                        .contentType(MediaType.APPLICATION_JSON))
                .andExpect(status().isBadRequest());
    }
}