package com.pt5.pthouduan.controller;

import com.pt5.pthouduan.entity.Comment;
import com.pt5.pthouduan.service.CommentService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.*;
import static org.junit.jupiter.api.Assertions.*;

class CommentControllerTest {

    @Mock
    private CommentService commentService;

    @InjectMocks
    private CommentController commentController;

    private MockMvc mockMvc;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(commentController).build();
    }

    @Test
    void createComment_ShouldReturnCreatedComment() {
        Comment inputComment = new Comment();
        inputComment.setPostid(1);
        inputComment.setUserid(100L);
        inputComment.setPostCommentcontent("Test Comment");
        inputComment.setCommenttime(LocalDateTime.now());

        Comment savedComment = new Comment();
        savedComment.setCommentid(1);
        savedComment.setPostid(1);
        savedComment.setUserid(100L);
        savedComment.setPostCommentcontent("Test Comment");
        savedComment.setCommenttime(inputComment.getCommenttime());

        when(commentService.createComment(any(Comment.class))).thenReturn(savedComment);

        Comment result = commentController.createComment(inputComment);

        assertNotNull(result);
        assertEquals("Test Comment", result.getPostCommentcontent());
        assertEquals(100L, result.getUserid());
    }

    @Test
    void deleteComment_ShouldReturnTrue_WhenSuccess() {
        when(commentService.deleteComment(1)).thenReturn(true);

        boolean result = commentController.deleteComment(1);

        assertTrue(result);
        verify(commentService).deleteComment(1);
    }

    @Test
    void updateComment_ShouldReturnTrue_WhenSuccess() {
        Comment updatedComment = new Comment();
        updatedComment.setCommentid(1);
        updatedComment.setPostCommentcontent("Updated content");

        when(commentService.updateComment(any(Comment.class))).thenReturn(true);

        boolean result = commentController.updateComment(updatedComment);

        assertTrue(result);
        verify(commentService).updateComment(updatedComment);
    }

    @Test
    void getCommentsByPostId_ShouldReturnListOfComments() {
        Comment comment1 = new Comment();
        comment1.setCommentid(1);
        comment1.setPostid(10);
        comment1.setPostCommentcontent("Comment 1");

        Comment comment2 = new Comment();
        comment2.setCommentid(2);
        comment2.setPostid(10);
        comment2.setPostCommentcontent("Comment 2");

        List<Comment> commentList = Arrays.asList(comment1, comment2);

        when(commentService.getCommentsByPostId(10)).thenReturn(commentList);

        List<Comment> result = commentController.getCommentsByPostId(10);

        assertEquals(2, result.size());
        assertEquals("Comment 1", result.get(0).getPostCommentcontent());
    }

    @Test
    void likeComment_ShouldReturnTrue_WhenSuccess() {
        when(commentService.likeComment(1)).thenReturn(true);

        boolean result = commentController.likeComment(1);

        assertTrue(result);
        verify(commentService).likeComment(1);
    }

    @Test
    void unlikeComment_ShouldReturnTrue_WhenSuccess() {
        when(commentService.unlikeComment(1)).thenReturn(true);

        boolean result = commentController.unlikeComment(1);

        assertTrue(result);
        verify(commentService).unlikeComment(1);
    }
}
