package com.pt5.pthouduan.controller;

import com.pt5.pthouduan.entity.FriendsList;
import com.pt5.pthouduan.service.FriendsListService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

class FriendsListControllerTest {

    @Mock
    private FriendsListService friendsListService;

    @InjectMocks
    private FriendsListController friendsListController;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
    }

    @Test
    void addFriend_ShouldReturnTrue_WhenSuccessful() {
        FriendsList request = new FriendsList();
        request.setFriend1(1L);
        request.setFriend2(2L);

        when(friendsListService.addFriend(any(FriendsList.class))).thenReturn(true);

        boolean result = friendsListController.addFriend(request);

        assertTrue(result);
        verify(friendsListService).addFriend(any(FriendsList.class));
    }

    @Test
    void acceptFriend_ShouldReturnTrue_WhenSuccessful() {
        when(friendsListService.acceptFriend(1L, 2L)).thenReturn(true);

        boolean result = friendsListController.acceptFriend(1L, 2L);

        assertTrue(result);
        verify(friendsListService).acceptFriend(1L, 2L);
    }

    @Test
    void deleteFriend_ShouldReturnTrue_WhenSuccessful() {
        when(friendsListService.deleteFriendByFriends(1L, 2L)).thenReturn(true);

        boolean result = friendsListController.deleteFriendByFriends(1L, 2L);

        assertTrue(result);
        verify(friendsListService).deleteFriendByFriends(1L, 2L);
    }

    @Test
    void getFriendsByUserId_ShouldReturnFriendList() {
        FriendsList f1 = new FriendsList();
        f1.setFriend1(1L);
        f1.setFriend2(2L);
        f1.setStatus("accepted");

        when(friendsListService.getAcceptedFriendsByUserId(1L)).thenReturn(List.of(f1));

        List<FriendsList> result = friendsListController.getFriendsByUserId(1L);

        assertEquals(1, result.size());
        assertEquals("accepted", result.get(0).getStatus());
    }

    @Test
    void getPendingRequests_ShouldReturnPendingList() {
        FriendsList pending = new FriendsList();
        pending.setFriend1(3L);
        pending.setFriend2(1L);
        pending.setStatus("pending");
        pending.setRequestTime(LocalDateTime.now());

        when(friendsListService.getPendingRequests(1L)).thenReturn(Arrays.asList(pending));

        List<FriendsList> result = friendsListController.getPendingRequests(1L);

        assertEquals(1, result.size());
        assertEquals("pending", result.get(0).getStatus());
        assertEquals(3L, result.get(0).getFriend1());
        assertEquals(1L, result.get(0).getFriend2());
    }
}
