package com.pt5.pthouduan.ControllerTest;

import com.pt5.pthouduan.controller.InvitesController;
import com.pt5.pthouduan.service.InviteService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.HashMap;
import java.util.Map;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.anyString;
import static org.mockito.Mockito.*;

class InvitesControllerTest {

    @Mock
    private InviteService inviteService;

    @InjectMocks
    private InvitesController invitesController;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
    }

    @Test
    void soldinvite_ShouldCallServiceWithCorrectParameter() {
        // 准备测试数据
        String testBuyerName = "testBuyer";
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", true);
        expectedResponse.put("message", "Invite sold successfully");

        // 模拟服务行为
        when(inviteService.setbuyername(anyString())).thenReturn(expectedResponse);

        // 执行测试
        Map<String, Object> actualResponse = invitesController.soldinvite(testBuyerName);

        // 验证行为
        verify(inviteService, times(1)).setbuyername(testBuyerName);

        // 验证结果
        assertEquals(expectedResponse, actualResponse);
        assertTrue((Boolean) actualResponse.get("success"));
        assertEquals("Invite sold successfully", actualResponse.get("message"));
    }

    @Test
    void soldinvite_ShouldHandleServiceFailure() {
        // 准备测试数据
        String testBuyerName = "testBuyer";
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", false);
        expectedResponse.put("error", "Invalid buyer name");

        // 模拟服务行为
        when(inviteService.setbuyername(anyString())).thenReturn(expectedResponse);

        // 执行测试
        Map<String, Object> actualResponse = invitesController.soldinvite(testBuyerName);

        // 验证行为
        verify(inviteService, times(1)).setbuyername(testBuyerName);

        // 验证结果
        assertEquals(expectedResponse, actualResponse);
        assertFalse((Boolean) actualResponse.get("success"));
        assertEquals("Invalid buyer name", actualResponse.get("error"));
    }

    @Test
    void soldinvite_ShouldHandleNullInput() {
        // 准备测试数据
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", false);
        expectedResponse.put("error", "Buyer name cannot be null");

        // 模拟服务行为
        when(inviteService.setbuyername(null)).thenReturn(expectedResponse);

        // 执行测试
        Map<String, Object> actualResponse = invitesController.soldinvite(null);

        // 验证行为
        verify(inviteService, times(1)).setbuyername(null);

        // 验证结果
        assertEquals(expectedResponse, actualResponse);
        assertFalse((Boolean) actualResponse.get("success"));
        assertEquals("Buyer name cannot be null", actualResponse.get("error"));
    }
}
