/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.tracker;

import com.turn.ttorrent.bcodec.BEValue;
import com.turn.ttorrent.common.LoggerUtils;
import com.turn.ttorrent.common.Peer;
import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.common.protocol.AnnounceRequestMessage;
import com.turn.ttorrent.common.protocol.TrackerMessage;
import com.turn.ttorrent.common.protocol.http.HTTPAnnounceRequestMessage;
import com.turn.ttorrent.common.protocol.http.HTTPAnnounceResponseMessage;
import com.turn.ttorrent.common.protocol.http.HTTPTrackerErrorMessage;
import com.turn.ttorrent.tracker.AddressChecker;
import com.turn.ttorrent.tracker.TorrentsRepository;
import com.turn.ttorrent.tracker.TrackedTorrent;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.simpleframework.http.Status;
import org.slf4j.Logger;

public class TrackerRequestProcessor {
    private static final Logger logger = TorrentLoggerFactory.getLogger(TrackerRequestProcessor.class);
    private static final String[] NUMERIC_REQUEST_FIELDS = new String[]{"port", "uploaded", "downloaded", "left", "compact", "no_peer_id", "numwant"};
    private static final int SEEDER_ANNOUNCE_INTERVAL = 150;
    private boolean myAcceptForeignTorrents = true;
    private int myAnnounceInterval = 60;
    private final AddressChecker myAddressChecker;
    private final TorrentsRepository myTorrentsRepository;

    public TrackerRequestProcessor(TorrentsRepository torrentsRepository) {
        this(torrentsRepository, new AddressChecker(){

            @Override
            public boolean isBadAddress(String ip) {
                return false;
            }
        });
    }

    public TrackerRequestProcessor(TorrentsRepository torrentsRepository, AddressChecker addressChecker) {
        this.myTorrentsRepository = torrentsRepository;
        this.myAddressChecker = addressChecker;
    }

    public void process(String uri, String hostAddress, RequestHandler requestHandler) throws IOException {
        boolean isSeeder;
        HTTPAnnounceRequestMessage announceRequest;
        try {
            announceRequest = this.parseQuery(uri, hostAddress);
        }
        catch (TrackerMessage.MessageValidationException mve) {
            LoggerUtils.warnAndDebugDetails(logger, "Unable to parse request message. Request url is {}", uri, mve);
            this.serveError(Status.BAD_REQUEST, mve.getMessage(), requestHandler);
            return;
        }
        AnnounceRequestMessage.RequestEvent event = announceRequest.getEvent();
        if (event == null) {
            event = AnnounceRequestMessage.RequestEvent.NONE;
        }
        TrackedTorrent torrent = this.myTorrentsRepository.getTorrent(announceRequest.getHexInfoHash());
        if (!this.myAcceptForeignTorrents && torrent == null) {
            logger.warn("Requested torrent hash was: {}", (Object)announceRequest.getHexInfoHash());
            this.serveError(Status.BAD_REQUEST, TrackerMessage.ErrorMessage.FailureReason.UNKNOWN_TORRENT, requestHandler);
            return;
        }
        boolean bl = isSeeder = event == AnnounceRequestMessage.RequestEvent.COMPLETED || announceRequest.getLeft() == 0L;
        if (this.myAddressChecker.isBadAddress(announceRequest.getIp())) {
            if (torrent == null) {
                this.writeEmptyResponse(announceRequest, requestHandler);
            } else {
                this.writeAnnounceResponse(torrent, null, isSeeder, requestHandler);
            }
            return;
        }
        Peer peer = new Peer(announceRequest.getIp(), announceRequest.getPort());
        try {
            torrent = this.myTorrentsRepository.putIfAbsentAndUpdate(announceRequest.getHexInfoHash(), new TrackedTorrent(announceRequest.getInfoHash()), event, ByteBuffer.wrap(announceRequest.getPeerId()), announceRequest.getHexPeerId(), announceRequest.getIp(), announceRequest.getPort(), announceRequest.getUploaded(), announceRequest.getDownloaded(), announceRequest.getLeft());
        }
        catch (IllegalArgumentException iae) {
            LoggerUtils.warnAndDebugDetails(logger, "Unable to update peer torrent. Request url is {}", uri, iae);
            this.serveError(Status.BAD_REQUEST, TrackerMessage.ErrorMessage.FailureReason.INVALID_EVENT, requestHandler);
            return;
        }
        this.writeAnnounceResponse(torrent, peer, isSeeder, requestHandler);
    }

    private void writeEmptyResponse(HTTPAnnounceRequestMessage announceRequest, RequestHandler requestHandler) throws IOException {
        try {
            HTTPAnnounceResponseMessage announceResponse = HTTPAnnounceResponseMessage.craft(this.myAnnounceInterval, 0, 0, Collections.emptyList(), announceRequest.getHexInfoHash());
            requestHandler.serveResponse(Status.OK.getCode(), Status.OK.getDescription(), announceResponse.getData());
        }
        catch (Exception e) {
            this.serveError(Status.INTERNAL_SERVER_ERROR, e.getMessage(), requestHandler);
        }
    }

    public void setAnnounceInterval(int announceInterval) {
        this.myAnnounceInterval = announceInterval;
    }

    public int getAnnounceInterval() {
        return this.myAnnounceInterval;
    }

    private void writeAnnounceResponse(TrackedTorrent torrent, Peer peer, boolean isSeeder, RequestHandler requestHandler) throws IOException {
        try {
            HTTPAnnounceResponseMessage announceResponse = HTTPAnnounceResponseMessage.craft(isSeeder ? 150 : this.myAnnounceInterval, torrent.seeders(), torrent.leechers(), isSeeder ? Collections.emptyList() : torrent.getSomePeers(peer), torrent.getHexInfoHash());
            requestHandler.serveResponse(Status.OK.getCode(), Status.OK.getDescription(), announceResponse.getData());
        }
        catch (Exception e) {
            this.serveError(Status.INTERNAL_SERVER_ERROR, e.getMessage(), requestHandler);
        }
    }

    private HTTPAnnounceRequestMessage parseQuery(String uri, String hostAddress) throws IOException, TrackerMessage.MessageValidationException {
        HashMap<String, BEValue> params = new HashMap<String, BEValue>();
        try {
            for (String pair : uri.split("[?]")[1].split("&")) {
                String[] keyval = pair.split("[=]", 2);
                if (keyval.length == 1) {
                    this.recordParam(params, keyval[0], null);
                    continue;
                }
                this.recordParam(params, keyval[0], keyval[1]);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            params.clear();
        }
        if (params.get("ip") == null) {
            params.put("ip", new BEValue(hostAddress, "ISO-8859-1"));
        }
        return HTTPAnnounceRequestMessage.parse(new BEValue(params));
    }

    private void recordParam(Map<String, BEValue> params, String key, String value) {
        try {
            value = URLDecoder.decode(value, "ISO-8859-1");
            for (String f : NUMERIC_REQUEST_FIELDS) {
                if (!f.equals(key)) continue;
                params.put(key, new BEValue((Number)Long.valueOf(value)));
                return;
            }
            params.put(key, new BEValue(value, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void serveError(Status status, HTTPTrackerErrorMessage error, RequestHandler requestHandler) throws IOException {
        requestHandler.serveResponse(status.getCode(), status.getDescription(), error.getData());
    }

    private void serveError(Status status, String error, RequestHandler requestHandler) throws IOException {
        this.serveError(status, HTTPTrackerErrorMessage.craft(error), requestHandler);
    }

    private void serveError(Status status, TrackerMessage.ErrorMessage.FailureReason reason, RequestHandler requestHandler) throws IOException {
        this.serveError(status, reason.getMessage(), requestHandler);
    }

    public void setAcceptForeignTorrents(boolean acceptForeignTorrents) {
        this.myAcceptForeignTorrents = acceptForeignTorrents;
    }

    public static interface RequestHandler {
        public void serveResponse(int var1, String var2, ByteBuffer var3);
    }
}

