/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client;

import com.turn.ttorrent.client.AnnounceableInformationImpl;
import com.turn.ttorrent.client.EventDispatcher;
import com.turn.ttorrent.client.LoadedTorrent;
import com.turn.ttorrent.client.TorrentMetadataProvider;
import com.turn.ttorrent.client.storage.PieceStorage;
import com.turn.ttorrent.common.AnnounceableInformation;
import com.turn.ttorrent.common.ImmutableTorrentHash;
import com.turn.ttorrent.common.TorrentHash;
import com.turn.ttorrent.common.TorrentMetadata;
import com.turn.ttorrent.common.TorrentStatistic;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LoadedTorrentImpl
implements LoadedTorrent {
    private final TorrentStatistic torrentStatistic;
    private final TorrentHash torrentHash;
    private final List<List<String>> announceUrls;
    private final String announce;
    private final PieceStorage pieceStorage;
    private final TorrentMetadataProvider metadataProvider;
    private final EventDispatcher eventDispatcher;

    LoadedTorrentImpl(TorrentStatistic torrentStatistic, TorrentMetadataProvider metadataProvider, TorrentMetadata torrentMetadata, PieceStorage pieceStorage, EventDispatcher eventDispatcher) {
        this.torrentStatistic = torrentStatistic;
        this.metadataProvider = metadataProvider;
        this.eventDispatcher = eventDispatcher;
        this.torrentHash = new ImmutableTorrentHash(torrentMetadata.getInfoHash());
        this.announceUrls = torrentMetadata.getAnnounceList() != null ? Collections.unmodifiableList(torrentMetadata.getAnnounceList()) : Collections.singletonList(Collections.singletonList(torrentMetadata.getAnnounce()));
        this.announce = torrentMetadata.getAnnounce();
        this.pieceStorage = pieceStorage;
    }

    @Override
    public PieceStorage getPieceStorage() {
        return this.pieceStorage;
    }

    @Override
    public TorrentMetadata getMetadata() {
        try {
            return this.metadataProvider.getTorrentMetadata();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to fetch torrent metadata from metadata provider: " + this.metadataProvider, e);
        }
    }

    @Override
    public TorrentStatistic getTorrentStatistic() {
        return this.torrentStatistic;
    }

    @Override
    @NotNull
    public AnnounceableInformation createAnnounceableInformation() {
        return new AnnounceableInformationImpl(this.torrentStatistic.getUploadedBytes(), this.torrentStatistic.getDownloadedBytes(), this.torrentStatistic.getLeftBytes(), this.torrentHash, this.announceUrls, this.announce);
    }

    @Override
    public TorrentHash getTorrentHash() {
        return this.torrentHash;
    }

    @Override
    public EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public String toString() {
        return "LoadedTorrentImpl{piece storage='" + this.pieceStorage + '\'' + ", metadata provider='" + this.metadataProvider + '\'' + '}';
    }
}

