/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.client.announce;

import com.turn.ttorrent.client.announce.HTTPTrackerClient;
import com.turn.ttorrent.client.announce.TrackerClient;
import com.turn.ttorrent.client.announce.TrackerClientFactory;
import com.turn.ttorrent.client.announce.UDPTrackerClient;
import com.turn.ttorrent.common.Peer;
import java.net.URI;
import java.net.UnknownHostException;
import java.net.UnknownServiceException;
import java.util.List;

public class TrackerClientFactoryImpl
implements TrackerClientFactory {
    @Override
    public TrackerClient createTrackerClient(List<Peer> peers, URI tracker) throws UnknownHostException, UnknownServiceException {
        String scheme = tracker.getScheme();
        if ("http".equals(scheme) || "https".equals(scheme)) {
            return new HTTPTrackerClient(peers, tracker);
        }
        if ("udp".equals(scheme)) {
            return new UDPTrackerClient(peers, tracker);
        }
        throw new UnknownServiceException("Unsupported announce scheme: " + scheme + "!");
    }
}

