/*
 * Decompiled with CFR 0.152.
 */
package com.turn.ttorrent.network.keyProcessors;

import com.turn.ttorrent.common.TorrentLoggerFactory;
import com.turn.ttorrent.network.ReadAttachment;
import com.turn.ttorrent.network.keyProcessors.KeyProcessor;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.slf4j.Logger;

public class InvalidKeyProcessor
implements KeyProcessor {
    private static final Logger logger = TorrentLoggerFactory.getLogger(InvalidKeyProcessor.class);

    @Override
    public void process(SelectionKey key) throws IOException {
        Object attachment = key.attachment();
        SelectableChannel channel = key.channel();
        if (attachment == null) {
            key.cancel();
            return;
        }
        if (!(attachment instanceof ReadAttachment)) {
            key.cancel();
            return;
        }
        if (!(channel instanceof SocketChannel)) {
            key.cancel();
            return;
        }
        SocketChannel socketChannel = (SocketChannel)channel;
        ReadAttachment readAttachment = (ReadAttachment)attachment;
        logger.trace("drop invalid key {}", (Object)channel);
        readAttachment.getConnectionListener().onError(socketChannel, new CancelledKeyException());
    }

    @Override
    public boolean accept(SelectionKey key) {
        return !key.isValid();
    }
}

