# CREATE TABLE cheating_records (
#                                   id BIGINT AUTO_INCREMENT PRIMARY KEY,
#                                   info_hash VARCHAR(40),
#                                   user_id BIGINT,
#                                   ip VARCHAR(45) NOT NULL,
#                                   port INT NOT NULL,
#                                   reason TEXT NOT NULL,
#                                   detected_at DATETIME NOT NULL,
#                                   INDEX idx_detected_at (detected_at)
# );

CREATE TABLE traffic_anomaly (
                                 id INT PRIMARY KEY AUTO_INCREMENT,
                                 info_hash VARCHAR(40) NOT NULL COMMENT '种子哈希',
                                 ip VARCHAR(45) NOT NULL COMMENT 'Peer IP',
                                 port INT NOT NULL COMMENT 'Peer 端口',
                                 upload_delta BIGINT NOT NULL COMMENT '本次上传增量（字节）',
                                 download_delta BIGINT NOT NULL COMMENT '本次下载增量（字节）',
                                 occur_time DATETIME DEFAULT CURRENT_TIMESTAMP COMMENT '异常发生时间'
);
CREATE TABLE client_anomaly (
                                id INT PRIMARY KEY AUTO_INCREMENT,
                                info_hash VARCHAR(40) NOT NULL COMMENT '种子哈希',
                                ip VARCHAR(45) NOT NULL COMMENT 'Peer IP',
                                port INT NOT NULL COMMENT 'Peer 端口',
                                peer_id VARCHAR(60) NOT NULL COMMENT '原始peer_id',
                                client_type VARCHAR(50) NOT NULL COMMENT '客户端类型（可疑/黑名单）',
                                occur_time DATETIME DEFAULT CURRENT_TIMESTAMP COMMENT '检测时间'
);
-- 存储文件级流量异常记录
CREATE TABLE IF NOT EXISTS file_traffic_anomaly (
                                                    id INT PRIMARY KEY AUTO_INCREMENT,
                                                    info_hash VARCHAR(40) NOT NULL COMMENT '种子哈希',
                                                    total_upload BIGINT NOT NULL COMMENT '总上传量（字节）',
                                                    total_download BIGINT NOT NULL COMMENT '总下载量（字节）',
                                                    create_time DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP COMMENT '记录时间'
);