package com.pt5.pthouduan.controller;

import com.pt5.pthouduan.entity.Comment;
import com.pt5.pthouduan.service.CommentService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.stereotype.Controller;

import java.util.List;

/**
 * <p>
 *  评论前端控制器
 * </p>
 *
 * 功能：增、删、改、查（按帖子ID）
 *
 * @author ym
 * @since 2025-04-14
 */
@CrossOrigin(origins = "http://localhost:5173")
@Controller
@RequestMapping("/comment")
public class CommentController {

    @Autowired
    private CommentService commentService;

    // 创建评论
    @PostMapping("/create")
    @ResponseBody
    public Comment createComment(@RequestBody Comment comment) {
    System.out.println("Received comment: " + comment);  // 输出接收到的评论数据
    return commentService.createComment(comment);
}

    // 删除评论（根据commentid）
    @DeleteMapping("/delete/{commentid}")
    @ResponseBody
    public boolean deleteComment(@PathVariable Integer commentid) {
        return commentService.deleteComment(commentid);
    }

    // 更新评论
    @PutMapping("/update")
    @ResponseBody
    public boolean updateComment(@RequestBody Comment comment) {
        return commentService.updateComment(comment);
    }

    // 获取某个帖子的所有评论
    @GetMapping("/post/{postid}")
    @ResponseBody
    public List<Comment> getCommentsByPostId(@PathVariable Integer postid) {
        return commentService.getCommentsByPostId(postid);
    }

    // 点赞评论
    @PostMapping("/like/{commentid}")
    @ResponseBody
    public boolean likeComment(@PathVariable Integer commentid) {
        return commentService.likeComment(commentid);
    }

    // 取消点赞评论
    @PostMapping("/unlike/{commentid}")
    @ResponseBody
    public boolean unlikeComment(@PathVariable Integer commentid) {
        return commentService.unlikeComment(commentid);
    }
}
