package com.pt5.pthouduan.controller;

import com.pt5.pthouduan.entity.FriendsList;
import com.pt5.pthouduan.service.FriendsListService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.stereotype.Controller;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 *  好友关系前端控制器
 * </p>
 *
 * 功能：添加好友、删除好友、查询好友
 *
 * @author ym
 * @since 2025-04-14
 */
@CrossOrigin(origins = "http://localhost:5173")
@Controller
@RequestMapping("/friends")
public class FriendsListController {

    @Autowired
    private FriendsListService friendsListService;

    // 添加好友（只是发起请求）
    @PostMapping("/add")
    @ResponseBody
    public boolean addFriend(@RequestBody FriendsList friendsList) {
        friendsList.setRequestTime(LocalDateTime.now());
        friendsList.setStatus("pending"); // 初始状态为申请中
        return friendsListService.addFriend(friendsList);
    }

    // 同意好友申请
    @PostMapping("/accept")
    @ResponseBody
    public boolean acceptFriend(@RequestParam Long friend1, @RequestParam Long friend2) {
        return friendsListService.acceptFriend(friend1, friend2);
    }

    @DeleteMapping("/delete")
    @ResponseBody
    public boolean deleteFriendByFriends(@RequestParam Long friend1, @RequestParam Long friend2) {
        return friendsListService.deleteFriendByFriends(friend1, friend2);
    }

    // 查询某用户的所有已通过好友
    @GetMapping("/list/{userid}")
    @ResponseBody
    public List<FriendsList> getFriendsByUserId(@PathVariable Long userid) {
        return friendsListService.getAcceptedFriendsByUserId(userid);
    }

    // （可选）查看自己收到的申请（自己是 friend2，status=pending）
    @GetMapping("/pending/{userid}")
    @ResponseBody
    public List<FriendsList> getPendingRequests(@PathVariable Long userid) {
        return friendsListService.getPendingRequests(userid);
    }
}
