package com.pt5.pthouduan.controller;

import com.pt5.pthouduan.entity.UserTrafficStat;
import com.pt5.pthouduan.mapper.UserTrafficMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.time.LocalDate;
import java.util.List;

@RestController
@RequestMapping("/api/traffic")
public class TrafficController {

    @Autowired
    private UserTrafficMapper userTrafficMapper;

    /**
     * 获取指定用户在指定时间范围内的上传和下载量统计
     * @param passkey 用户唯一标识（passkey）
     * @param startDate 开始时间（格式：yyyy-MM-dd）
     * @param endDate 结束时间（格式：yyyy-MM-dd）
     * @return 该用户的上传和下载量统计
     */
    @GetMapping("/user-stats")
    public ResponseEntity<UserTrafficStat> getUserTrafficStats(
            @RequestParam String passkey,  // 必须传入 passkey
            @RequestParam @DateTimeFormat(iso = DateTimeFormat.ISO.DATE) LocalDate startDate,
            @RequestParam @DateTimeFormat(iso = DateTimeFormat.ISO.DATE) LocalDate endDate) {

        // 调用 Mapper 查询数据
        UserTrafficStat stats = userTrafficMapper.getUserTrafficStats(passkey, startDate, endDate);

        return ResponseEntity.ok(stats);
    }
}