package com.pt5.pthouduan.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 用户行为记录表
 * </p>
 *
 * @author ljx
 * @since 2025-06-04
 */
@TableName("user_behavior")
public class UserBehavior implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId("behavior_id")
    private Long behaviorId;    //行为id

    private Long userId;        // 用户ID

    private Long torrentId;     // 种子资源ID

    private String behaviorType; // 行为类型：VIEW/DOWNLOAD/FAVORITE等

    private Integer weight;     // 行为权重

    private LocalDateTime timestamp; // 行为时间

    public Long getBehaviorId() {
        return behaviorId;
    }

    public void setBehaviorId(Long behaviorId) {
        this.behaviorId = behaviorId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getTorrentId() {
        return torrentId;
    }

    public void setTorrentId(Long torrentId) {
        this.torrentId = torrentId;
    }

    public String getBehaviorType() {
        return behaviorType;
    }

    public void setBehaviorType(String behaviorType) {
        this.behaviorType = behaviorType;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public LocalDateTime getTimestamp() {
        return timestamp;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String toString() {
        return "UserBehavior{" +
                "behaviorId=" + behaviorId +
                ", userId=" + userId +
                ", torrentId=" + torrentId +
                ", behaviorType='" + behaviorType + '\'' +
                ", weight=" + weight +
                ", timestamp=" + timestamp +
                '}';
    }
}