package com.pt5.pthouduan.mapper;

import com.pt5.pthouduan.entity.FriendsList;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 *  好友关系 Mapper 接口
 * </p>
 *
 * 功能：
 *  - 添加好友请求
 *  - 同意好友请求
 *  - 删除好友
 *  - 查询某用户所有好友
 *  - 查询待处理的好友请求
 *
 * @author 杨蔓
 * @since 2025-04-14
 */
@Mapper
public interface FriendsListMapper extends BaseMapper<FriendsList> {

    // 插入好友申请（status = "pending"）
    int insertFriendRequest(FriendsList friendsList);

    // 同意好友申请（更新 status = "accepted"）
    int updateFriendStatus(@Param("friend1") Long friend1,
                           @Param("friend2") Long friend2,
                           @Param("status") String status);

    // 删除好友（无论谁是 friend1 或 friend2）
    int deleteByFriendPair(@Param("friend1") Long friend1,
                           @Param("friend2") Long friend2);

    // 查询某用户所有已通过好友（status = "accepted"）
    List<FriendsList> selectAcceptedFriends(@Param("userid") Long userid);

    // 查询自己收到的好友请求（自己是 friend2，status = "pending"）
    List<FriendsList> selectPendingRequests(@Param("userid") Long userid);
}
