package com.pt5.pthouduan.mapper;

import com.pt5.pthouduan.entity.request_resources;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * <p>
 * 求助帖 Mapper 接口
 * </p>
 *
 * 功能：创建、修改金额、删除、按名称/用户/被协助用户查询、统计某名称总金额
 * 可扩展自定义 SQL
 *
 * @author ym
 * @since 2025-05-10
 */
@Mapper
public interface RequestResourcesMapper extends BaseMapper<request_resources> {

    // 创建求助帖（可选，BaseMapper 已有 insert 方法）
    void save(request_resources request);

    // 修改求助帖金额
    int updateMoney(@Param("requestid") Integer requestid, @Param("money") Integer money);

    // 根据名称查询求助帖
    List<request_resources> selectByName(@Param("name") String name);

    // 计算某个名称对应的总金额
    Integer sumMoneyByName(@Param("name") String name);

    // 根据发帖人 ID 查询求助帖
    List<request_resources> selectByUserid(@Param("userid") Long userid);

    // 根据被协助人 ID 查询求助帖
    List<request_resources> selectByLoaduser(@Param("loaduser") Long loaduser);

    // ✅ 批量更新被协助用户 ID（loaduser）
    int updateLoaduserByName(@Param("name") String name, @Param("loaduser") Long loaduser);

    // ✅ 获取所有求助帖
    List<request_resources> selectAllRequests();

    // ✅ 1. 根据 requestid 更新 torrentid
    int updateTorrentid(@Param("requestid") Integer requestid, @Param("torrentid") Long torrentid);

    // ✅ 2. 根据 requestid 查询单个求助帖（BaseMapper 已有 selectById，但保留自定义扩展性）
    request_resources selectByRequestid(@Param("requestid") Integer requestid);

    // ✅ 3. 根据 userid + name + plot 查询唯一 request（用于获取 requestid）
    request_resources findByUseridNamePlot(@Param("userid") Long userid,
                                           @Param("name") String name,
                                           @Param("plot") String plot);
}
