package com.pt5.pthouduan.mapper;

import com.pt5.pthouduan.entity.UserTrafficStat;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDate;
import java.util.List;

@Mapper
public interface UserTrafficMapper {
    /**
     * 查询指定用户在指定时间范围内的上传和下载量（按月统计）
     * @param passkey 用户唯一标识
     * @param startDate 开始时间
     * @param endDate 结束时间
     * @return 该用户的月度统计
     */
    UserTrafficStat getUserTrafficStats(
            @Param("passkey") String passkey,
            @Param("startDate") LocalDate startDate,
            @Param("endDate") LocalDate endDate);
}