package com.pt5.pthouduan.service;

import com.pt5.pthouduan.entity.Comment;

import java.util.List;

/**
 * <p>
 * 评论服务接口
 * </p>
 *
 * 功能：增、删、改、查（按帖子ID）
 *
 * @author ym
 * @since 2025-04-14
 */
public interface CommentService {

    // 创建评论
    Comment createComment(Comment comment);

    // 删除评论
    boolean deleteComment(Integer commentid);

    // 更新评论
    boolean updateComment(Comment comment);

    // 根据帖子ID获取所有评论
    List<Comment> getCommentsByPostId(Integer postid);

    // 点赞评论
    boolean likeComment(Integer commentid);

    // 取消点赞评论
    boolean unlikeComment(Integer commentid);

}
