package com.pt5.pthouduan.service;

import com.pt5.pthouduan.entity.Invites;
import com.pt5.pthouduan.entity.User;
import com.pt5.pthouduan.entity.UserTrafficStat;
import com.pt5.pthouduan.mapper.InvitesMapper;
import com.pt5.pthouduan.mapper.UserMapper;
import com.pt5.pthouduan.mapper.UserTrafficMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class ExamService {
    @Autowired
    private UserTrafficMapper userTrafficMapper;
    @Autowired
    private UserMapper userMapper;
    //所有用户月度下载量考核
    public Map<String, Object> MonthDownload(LocalDate startDate,LocalDate endDate){
        Map<String, Object> result = new HashMap<>();
        List<Map<String, Object>> users = userMapper.selectAllUsersBasicInfo();
        for (Map<String, Object> user : users) {
            // 获取 gradeId，这里转为数字
            Object gradeIdObj = user.get("grade_id");
            int gradeId = (gradeIdObj instanceof Number) ? ((Number) gradeIdObj).intValue() : 0;
            UserTrafficStat userTrafficStat=userTrafficMapper.getUserTrafficStats((String) user.get("passkey"),startDate,endDate);
            System.out.println(gradeId+" "+userTrafficStat.getTotalUploaded()+"  "+userTrafficStat.getTotalDownloaded());
            // 根据 gradeId 的值审核下载量
            if (gradeId == 1) {
                if(userTrafficStat.getTotalDownloaded()<1073741824){
                    if(userTrafficStat.getTotalUploaded()< 1073741824L *50)
                        failure((String) user.get("username"),gradeId);
                }
            } else if (gradeId == 2) {
                if(userTrafficStat.getTotalDownloaded()< 1073741824L *3){
                    if(userTrafficStat.getTotalUploaded()< 1073741824L *50)
                        failure((String) user.get("username"),gradeId);
                }
            } else if (gradeId == 3) {
                if(userTrafficStat.getTotalDownloaded()< 1073741824L *5){
                    if(userTrafficStat.getTotalUploaded()< 1073741824L *50)
                        failure((String) user.get("username"),gradeId);
                }
            }
        }
        result.put("success", true);
        result.put("message", "用户月度考核完毕");
        return result;
    }
    //考核失败
    void failure(String username,int gradeId){
        System.out.println("failure"+username+gradeId);
        if(gradeId == 1){
            userMapper.deleteByUsername(username);
        }else{
            userMapper.updateGrade(username,gradeId-1);
        }
    }
    //所有用户季度上传量考核
    public Map<String, Object> QuarterUpload(LocalDate startDate,LocalDate endDate){
        Map<String, Object> result = new HashMap<>();
        List<Map<String, Object>> users = userMapper.selectAllUsersBasicInfo();
        for (Map<String, Object> user : users) {
            // 获取 gradeId，这里转为数字
            Object gradeIdObj = user.get("grade_id");
            int gradeId = (gradeIdObj instanceof Number) ? ((Number) gradeIdObj).intValue() : 0;
            UserTrafficStat userTrafficStat=userTrafficMapper.getUserTrafficStats((String) user.get("passkey"),startDate,endDate);
            // 根据 gradeId 的值审核上传
            if (gradeId == 1) {
                if(userTrafficStat.getTotalUploaded()< 1073741824L *50){
                    failure((String) user.get("username"),gradeId);
                }
            } else if (gradeId == 2) {
                if(userTrafficStat.getTotalUploaded()< 1073741824L*60){
                    failure((String) user.get("username"),gradeId);
                }
            } else if (gradeId == 3) {
                System.out.println("here");
                if(userTrafficStat.getTotalUploaded()< 1073741824L*70){
                    System.out.println("failure");
                    failure((String) user.get("username"),gradeId);
                }
            }else if (gradeId == 4) {
                if(userTrafficStat.getTotalUploaded()< 1073741824L*80){
                    failure((String) user.get("username"),gradeId);
                }
            }else if (gradeId == 5) {
                if(userTrafficStat.getTotalUploaded()< 1073741824L*100){
                    failure((String) user.get("username"),gradeId);
                }
            }
        }
        result.put("success", true);
        result.put("message", "用户季度考核完毕");
        return result;
    }
}