package com.pt5.pthouduan.service;

import com.pt5.pthouduan.entity.request_resources;

import java.util.List;

public interface RequestResourcesService {

    // 创建求助帖
    boolean createRequest(request_resources request);

    // 修改求助帖金额
    boolean updateMoney(Integer requestid, Integer money);

    // 删除求助帖
    boolean deleteRequest(Integer requestid);

    // 根据名称查找求助帖
    List<request_resources> findByName(String name);

    // 计算某名称的求助帖总金额
    Integer calculateTotalMoneyByName(String name);

    // 根据发帖用户ID查找求助帖
    List<request_resources> findByUserid(Long userid);

    // 根据被协助用户ID查找求助帖
    List<request_resources> findByLoaduser(Long loaduser);

    // 根据帖子名称批量更新loaduser字段
    boolean updateLoaduserByName(String name, Long loaduser);

    // 展示所有求助帖
    List<request_resources> getAllRequests();

    // ✅ 新增：根据 requestid 更新 torrentid
    boolean updateTorrentid(Integer requestid, Long torrentid);

    // ✅ 新增：根据 requestid 查询 request 对象
    request_resources findByRequestid(Integer requestid);

    // ✅（可选）根据 userid + name + plot 查询 requestid
    request_resources findByUseridAndNameAndPlot(Long userid, String name, String plot);
}
