package com.pt5.pthouduan.service;

import com.pt5.pthouduan.entity.Invites;
import com.pt5.pthouduan.mapper.InvitesMapper;
import com.pt5.pthouduan.mapper.ShopMapper;
import com.pt5.pthouduan.mapper.UserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

@Service
public class ShopService {
    @Autowired
    private InvitesMapper invitesMapper;
    @Autowired
    private UserMapper userMapper;
    //外观类订单
    public Map<String, Object> buyDecoration(String buyername,String decoration,int price){//decoration指的是外观编号或id
        Map<String, Object> result = new HashMap<>();
        //首先查询用户是否拥有足够的保种积分
        int credit=userMapper.getcreditByUsername(buyername);
        if(credit<price){
            result.put("success", false);
            result.put("message", "余额不足");
            return result;
        }
        //更新用户保种积分
        userMapper.deductCreditByUsername(buyername,price);
        //更新用户数据库
        userMapper.appendUserDecoration(buyername,decoration);
        //更新订单数据库 To do...
        result.put("success", true);
        result.put("message", "外观购买成功");
        return result;
    }
    //上传量类订单
    public Map<String, Object> buyUpload(String buyername,int price,int upload){
        Map<String, Object> result = new HashMap<>();
        //首先查询用户是否拥有足够的保种积分
        int credit=userMapper.getcreditByUsername(buyername);
        if(credit<price){
            result.put("success", false);
            result.put("message", "余额不足");
            return result;
        }
        //更新用户保种积分
        userMapper.deductCreditByUsername(buyername,price);
       //更新用户上传量
        userMapper.increaseUploadByUsername(buyername,upload);
        result.put("success", true);
        result.put("message", "上传量购买成功");
        return result;
    }
    //购买邀请码
    public Map<String, Object> setbuyername(String buyername,int price){
        Map<String, Object> result = new HashMap<>();
        //首先查询用户是否拥有足够的保种积分
        int credit=userMapper.getcreditByUsername(buyername);
        if(credit<price){
            result.put("success", false);
            result.put("message", "余额不足");
            return result;
        }
        //更新用户保种积分
        userMapper.deductCreditByUsername(buyername,price);
        Map<String, Object> invite=invitesMapper.selectFirstEmptyBuyername();
        invitesMapper.updatebuyer((String) invite.get("code"),buyername);
        result.put("success", true);
        result.put("invitecode", (String) invite.get("code"));
        result.put("message", "邀请码购买成功");
        return result;
    }



}