package com.pt5.pthouduan.service;
import com.pt5.pthouduan.entity.Invites;
import com.pt5.pthouduan.entity.User;
import com.pt5.pthouduan.mapper.InvitesMapper;
import lombok.extern.java.Log;
import org.springframework.beans.factory.annotation.Autowired;
import com.pt5.pthouduan.mapper.UserMapper;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;
import java.security.SecureRandom;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

@Service
public class UserService {
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private InvitesMapper invitesMapper;
    @Autowired
    private EmailService emailService;
    //发送验证码
    public Map<String, Object> sendCode(String email){
        Map<String, Object> result = new HashMap<>();
        emailService.sendVerificationCode(email);
        result.put("success", true);
        result.put("message", "验证码发送成功");
        return result;
    }
    // 注册业务
    public Map<String, Object> register(User user,String code,String emailcode) {
        Map<String, Object> result = new HashMap<>();

        // 参数校验
        if (!StringUtils.hasText(user.getUsername())){
            result.put("success", false);
            result.put("message", "用户名不能为空");
            return result;
        }

        if (!StringUtils.hasText(user.getPassword())) {
            result.put("success", false);
            result.put("message", "密码不能为空");
            return result;
        }

        // 检查用户名是否已存在
        if (userMapper.selectByUsername(user.getUsername()) != null) {
            result.put("success", false);
            result.put("message", "用户名已存在");
            return result;
        }

//        // 检查邮箱是否已存在
//        if (userMapper.selectByEmail(user.getEmail()) != null) {
//            result.put("success", false);
//            result.put("message", "邮箱已注册");
//            return result;
//        }
        //检查邀请码是否有效
        Map<String, Object> invite= invitesMapper.selectByCode(code);
        if(invite==null){//邀请码不存在
            result.put("success", false);
            result.put("message","无效的邀请码");
            return result;
        }
        Boolean isused = (Boolean) invite.get("isUsed");
        if(isused){//邀请码已被使用
            result.put("success", false);
            result.put("message","邀请码已被使用");
            return result;
        }
        //邮箱验证码验证
        if (!emailService.verifyCode(user.getEmail(), emailcode)) {
            result.put("success", false);
            result.put("message","验证码错误");
            return result;
        }
        //生成passkey
        SecureRandom random = new SecureRandom();
        user.setPasskey(String.valueOf(10000000 + random.nextInt(90000000)));
        // 保存用户
        userMapper.insert(user);
        invitesMapper.updateInviteByCode(code,user.getUsername());
        result.put("success", true);
        result.put("message", "注册成功");
        return result;
    }
    //

    // 登录业务
    public Map<String, Object> login(String username, String password) {
        Map<String, Object> result = new HashMap<>();

        Map<String, Object> user = userMapper.selectByUsername(username);//首先验证用户名
        if (user == null) {
            result.put("success", false);
            result.put("message", "用户不存在");
            return result;
        }

        //验证密码
        if(!password.equals(user.get("password"))){
            result.put("success", false);
            result.put("message","密码错误，请检查后重新输入");
            return result;
        }
        // 登录成功，返回用户信息(密码置空)
        result.put("success", true);
        result.put("message", "登录成功");
        result.put("user", user);
        return result;
    }
    //更新用户等级
    public Map<String, Object> CalGrade(String username){
        Map<String, Object> result = new HashMap<>();
        //上传量+下载量0-500000 一级  510000-2000000 二级 2010000-3500000 三级 3510000-6500000 四级 6500000以上 五级
        Map<String, Object> user = userMapper.selectByUsername(username);
        Number downloadNum = (Number) user.get("user_download");
        long download = downloadNum.longValue();
        Number uploadNum = (Number) user.get("user_upload");
        long upload = uploadNum.longValue();
        int grade=0;
        if(upload+download<=500000*1024){
            grade=1;
        }else if(upload+download<=2000000*1024){
            grade=2;
        }else if(upload+download<= 3500000L *1024){
            grade=3;
        }else if(upload+download<= 6500000L *1024){
            grade=4;
        }else{ grade=5;}
        userMapper.updateGrade(username,grade);
        result.put("success", true);
        result.put("message", "等级更新成功");
        result.put("grade", grade);
        return result;
    }
    //设置性别
    public Map<String, Object> changesex(String username,String sex){
        Map<String, Object> result = new HashMap<>();
        userMapper.updatesex(username,sex);
        result.put("success", true);
        result.put("message", "性别设置成功");
        return result;
    }
    //设置头像
    public Map<String, Object> changeImage(String username,String image){
        Map<String, Object> result = new HashMap<>();
        userMapper.updateimage(username,image);
        result.put("success", true);
        result.put("message", "头像设置成功");
        return result;
    }
    //更改密码
    public Map<String, Object> changePassword(String username,String oldpassword,String newpassword){
        Map<String, Object> result = new HashMap<>();
        Map<String, Object> user = userMapper.selectByUsername(username);//首先验证用户名
        if (user == null) {
            result.put("success", false);
            result.put("message", "用户不存在");
            return result;
        }

        //验证密码
        if(!oldpassword.equals(user.get("password"))){
            result.put("success", false);
            result.put("message","密码错误，请检查后重新输入");
            return result;
        }
        //更改数据库中的密码
        userMapper.updatePassword(username,newpassword);
        result.put("success", true);
        result.put("message", "密码重置成功");
        return result;
    }
    //获取用户信息（前端）
    public Map<String, Object> UserInfo(String username){
        Map<String, Object> result = new HashMap<>();
        Map<String, Object> user = userMapper.selectByUsername(username);
        result.put("success", true);
        result.put("message", "用户信息获取成功");
        result.put("user", user);
        return result;
    }
    //直接创建用户
    public Map<String, Object> CreateUser(User user){//用户名、密码、邮箱
        Map<String, Object> result = new HashMap<>();
        SecureRandom random = new SecureRandom();
        user.setPasskey(String.valueOf(10000000 + random.nextInt(90000000)));
        userMapper.insert(user);
        result.put("success", true);
        result.put("message", "用户创建成功");
        return result;
    }
    //直接删除用户
    public Map<String, Object> DeleteUser(String username){
        Map<String, Object> result = new HashMap<>();
        userMapper.deleteByUsername(username);
        result.put("success", true);
        result.put("message", "用户删除成功");
        return result;
    }
    //获取所有用户
    public Map<String, Object> getAllUser(){
        Map<String, Object> result = new HashMap<>();
        List<Map<String, Object>> users =userMapper.selectAllUsers();
        result.put("data", users);
        result.put("success", true);
        result.put("message", "用户获取成功");
        return result;
    }
    //模糊搜索用户名
    public Map<String, Object> findUser(String keyword){
        Map<String, Object> result = new HashMap<>();
        String regexPattern = keyword.chars()
                .mapToObj(c -> String.valueOf((char) c))
                .collect(Collectors.joining(".*"));
        List<Map<String, Object>> users = userMapper.selectUserByFuzzyKeyword(regexPattern);
        result.put("data", users);
        result.put("success", true);
        result.put("message", "用户查找成功");
        return result;
    }
    //根据用户id返回用户的头像和装饰
    public Map<String, Object> getDecoration(Long userid){
        Map<String, Object> result = new HashMap<>();
        Map<String, Object> info = userMapper.selectdecorationByUserid(userid);
        result.put("data", info);
        result.put("success", true);
        result.put("message", "获取信息成功");
        return result;
    }
    //根据用户名返回用户id
    public Map<String, Object> getuserid(String username){
        Map<String, Object> result = new HashMap<>();
        String userid = userMapper.selectUseridByusername(username);
        result.put("data",userid);
        result.put("success", true);
        result.put("message", "获取信息成功");
        return result;
    }

}
