package com.pt5.pthouduan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.pt5.pthouduan.entity.request_resources;
import com.pt5.pthouduan.mapper.RequestResourcesMapper;
import com.pt5.pthouduan.service.RequestResourcesService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class RequestResourcesServiceImpl implements RequestResourcesService {

    @Autowired
    private RequestResourcesMapper requestResourcesMapper;

    // 创建求助帖
    @Override
    public boolean createRequest(request_resources request) {
        return requestResourcesMapper.insert(request) > 0;
    }

    // 修改求助帖金额
    @Override
    public boolean updateMoney(Integer requestid, Integer money) {
        request_resources request = requestResourcesMapper.selectById(requestid);
        if (request != null) {
            request.setMoney(money);
            return requestResourcesMapper.updateById(request) > 0;
        }
        return false;
    }

    // 删除求助帖
    @Override
    public boolean deleteRequest(Integer requestid) {
        return requestResourcesMapper.deleteById(requestid) > 0;
    }

    // 根据名称查找求助帖
    @Override
    public List<request_resources> findByName(String name) {
        QueryWrapper<request_resources> wrapper = new QueryWrapper<>();
        wrapper.eq("name", name);
        return requestResourcesMapper.selectList(wrapper);
    }

    // 计算某名称的求助帖总金额
    @Override
    public Integer calculateTotalMoneyByName(String name) {
        QueryWrapper<request_resources> wrapper = new QueryWrapper<>();
        wrapper.eq("name", name).select("money");
        List<request_resources> list = requestResourcesMapper.selectList(wrapper);
        return list.stream()
                .map(request_resources::getMoney)
                .reduce(0, Integer::sum);
    }

    // 根据发帖用户ID查找求助帖
    @Override
    public List<request_resources> findByUserid(Long userid) {
        QueryWrapper<request_resources> wrapper = new QueryWrapper<>();
        wrapper.eq("userid", userid);
        return requestResourcesMapper.selectList(wrapper);
    }

    // 根据被协助用户ID查找求助帖
    @Override
    public List<request_resources> findByLoaduser(Long loaduser) {
        QueryWrapper<request_resources> wrapper = new QueryWrapper<>();
        wrapper.eq("loaduser", loaduser);
        return requestResourcesMapper.selectList(wrapper);
    }

    // 批量更新 loaduser
    @Override
    public boolean updateLoaduserByName(String name, Long loaduser) {
        UpdateWrapper<request_resources> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("name", name).set("loaduser", loaduser);
        return requestResourcesMapper.update(null, updateWrapper) > 0;
    }

    // 获取所有求助帖
    @Override
    public List<request_resources> getAllRequests() {
        return requestResourcesMapper.selectList(null);
    }

    // ✅ 新增：根据 requestid 更新 torrentid
    @Override
    public boolean updateTorrentid(Integer requestid, Long torrentid) {
        UpdateWrapper<request_resources> updateWrapper = new UpdateWrapper<>();
        updateWrapper.eq("requestid", requestid).set("torrentid", torrentid);
        return requestResourcesMapper.update(null, updateWrapper) > 0;
    }

    // ✅ 新增：根据 requestid 查询对象
    @Override
    public request_resources findByRequestid(Integer requestid) {
        return requestResourcesMapper.selectById(requestid);
    }

    // ✅ 新增：根据 userid + name + plot 查找唯一 request（获取 requestid 用）
    @Override
    public request_resources findByUseridAndNameAndPlot(Long userid, String name, String plot) {
        QueryWrapper<request_resources> wrapper = new QueryWrapper<>();
        wrapper.eq("userid", userid)
                .eq("name", name)
                .eq("plot", plot);
        return requestResourcesMapper.selectOne(wrapper);
    }
}
