package com.pt5.pthouduan.service.impl;

import com.pt5.pthouduan.mapper.UserMapper;
import com.turn.ttorrent.tracker.Tracker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.sql.DataSource;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import static com.pt5.pthouduan.util.TorrentUtils.hexStringToByteArray;

@Service
public class updatePeerStatsService {

    @Autowired
    private DataSource dataSource;

    @Autowired
    private UserMapper userMapper;


    public void updatePeerStatsInDB(String infoHash, String ip, int port, String peerId,
                                    long uploaded, long downloaded, long deltaUpload,
                                    long deltaDownload, String passkey, String event,
                                    long left) {
        double shareRatio = downloaded == 0 ? 0.0 : (double) uploaded / downloaded;

        //记得在config里面写一下
        int intervalSeconds = 100;
        String username = userMapper.getUsernameByPasskey(passkey); // ← 获取用户名
        String client = parseClientFromPeerId(peerId);              // ← 解析客户端
        // 记录可疑客户端
        if (client.startsWith("Suspicious_") || client.startsWith("Blacklisted_")||client.startsWith("Other")) {
            recordSuspiciousClient(infoHash, ip, port, peerId, client);
        }

        System.out.println("剩下的：" + left);
        boolean isCompleted = left == 0;
        double uploadSpeed = intervalSeconds > 0 ? (double) deltaUpload / intervalSeconds : 0.0;
        double downloadSpeed = intervalSeconds > 0 ? (double) deltaDownload / intervalSeconds : 0.0;

//        String sql = """
//            INSERT INTO peer_stats (info_hash, ip, port, peer_id, uploaded, downloaded, delta_upload, delta_download, share_ratio, passkey)
//            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
//            ON DUPLICATE KEY UPDATE
//                uploaded = VALUES(uploaded),
//                downloaded = VALUES(downloaded),
//                delta_upload = VALUES(delta_upload),
//                delta_download = VALUES(delta_download),
//                share_ratio = VALUES(share_ratio),
//                last_updated = CURRENT_TIMESTAMP,
//                passkey = VALUES(passkey);
//            """;
//
//        try (Connection conn = dataSource.getConnection();
//             PreparedStatement stmt = conn.prepareStatement(sql)) {
//
//            stmt.setString(1, infoHash);
//            stmt.setString(2, ip);
//            stmt.setInt(3, port);
//            stmt.setString(4, peerId);
//            stmt.setLong(5, uploaded);
//            stmt.setLong(6, downloaded);
//            stmt.setLong(7, deltaUpload);
//            stmt.setLong(8, deltaDownload);
//            stmt.setDouble(9, shareRatio);
//            stmt.setString(10, passkey);
//
//            stmt.executeUpdate();
        String sql = """
    INSERT INTO peer_stats (
        info_hash, ip, port, peer_id, uploaded, downloaded,
        delta_upload, delta_download, share_ratio, passkey,
        username, last_event, last_updated, client, created_at,
        completed_time, upload_speed, download_speed
    )
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, CURRENT_TIMESTAMP, ?, CURRENT_TIMESTAMP, ?, ?, ?)
    ON DUPLICATE KEY UPDATE
        uploaded = VALUES(uploaded),
        downloaded = VALUES(downloaded),
        delta_upload = VALUES(delta_upload),
        delta_download = VALUES(delta_download),
        share_ratio = VALUES(share_ratio),
        last_updated = CURRENT_TIMESTAMP,
        last_event = VALUES(last_event),
        username = VALUES(username),
        client = VALUES(client),
        passkey = VALUES(passkey),
        completed_time = IF(VALUES(completed_time) IS NOT NULL, VALUES(completed_time), completed_time),
        upload_speed = VALUES(upload_speed),
        download_speed = VALUES(download_speed);
""";

        try (Connection conn = dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql)) {

            stmt.setString(1, infoHash);               // info_hash
            stmt.setString(2, ip);                     // ip
            stmt.setInt(3, port);                      // port
            stmt.setString(4, peerId);                 // peer_id
            stmt.setLong(5, uploaded);                 // uploaded
            stmt.setLong(6, downloaded);               // downloaded
            stmt.setLong(7, deltaUpload);              // delta_upload
            stmt.setLong(8, deltaDownload);            // delta_download
            stmt.setDouble(9, shareRatio);             // share_ratio
            stmt.setString(10, passkey);               // passkey
            stmt.setString(11, username);              // username
            stmt.setString(12, event);                 // last_event
            // last_updated = CURRENT_TIMESTAMP (in SQL)
            stmt.setString(13, client);                // client
            // created_at = CURRENT_TIMESTAMP (in SQL)
            stmt.setTimestamp(14, isCompleted ? new java.sql.Timestamp(System.currentTimeMillis()) : null);  // completed_time
            stmt.setDouble(15, uploadSpeed);           // upload_speed
            stmt.setDouble(16, downloadSpeed);         // download_speed
//completetime还要再检查一下
            stmt.executeUpdate();

            // ✅ 成功写入后更新 user 表
            userMapper.incrementUserTraffic(infoHash.toLowerCase(),passkey, deltaUpload, deltaDownload);

        } catch (SQLException e) {
            e.printStackTrace(); // 建议替换为日志系统
        }
    }
    public static String parseClientFromPeerId(String peerId) {
        String peerIdHex = peerId;
        byte[] peerIdBytes = hexStringToByteArray(peerIdHex);
        String decodedPeerId = new String(peerIdBytes, StandardCharsets.UTF_8);
        System.out.println("Decoded Peer ID: " + decodedPeerId);
        System.out.println("客户端："+ peerId);
        if (peerId == null || peerId.length() < 6) return "Unknown";

        if (decodedPeerId.startsWith("-UT")) return "uTorrent";
        if (decodedPeerId.startsWith("-TR")) return "Transmission";
        if (decodedPeerId.startsWith("-AZ")) return "Azureus";
        if (decodedPeerId.startsWith("-LT")) return "libtorrent";
        if (decodedPeerId.startsWith("-qB")) return "qBittorrent";
        if (decodedPeerId.startsWith("-DE")) return "Deluge";      // 新增：Deluge客户端
        if (decodedPeerId.startsWith("-BT")) return "BitTorrent";  // 新增：BitTorrent客户端

        // 黑名单客户端识别
        if (decodedPeerId.startsWith("-FAKE")) return "Blacklisted_FakeClient";  // 伪造客户端
        if (decodedPeerId.startsWith("-HACK")) return "Blacklisted_HackedClient"; // 破解客户端
        // 未识别的非常见客户端（长度不足或无匹配前缀）
        if (decodedPeerId.length() < 6) return "Suspicious_TooShort";  // 长度异常




        return "Other";
    }
    //记录流量异常
    public void recordTrafficAnomaly(String infoHash, String ip, int port, long uploadDelta, long downloadDelta) {
        String sql = """
            INSERT INTO traffic_anomaly (info_hash, ip, port, upload_delta, download_delta)
            VALUES (?, ?, ?, ?, ?)
        """;
        try (Connection conn = dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql)) {
            stmt.setString(1, infoHash);
            stmt.setString(2, ip);
            stmt.setInt(3, port);
            stmt.setLong(4, uploadDelta);
            stmt.setLong(5, downloadDelta);
            stmt.executeUpdate();
        } catch (SQLException e) {
            //logger.error("记录流量异常失败，info_hash={}, ip={}:{}", infoHash, ip, port, e);
        }
    }
    //记录可疑客户端
    public void recordSuspiciousClient(String infoHash, String ip, int port, String peerId, String clientType) {
        String sql = """
            INSERT INTO client_anomaly (info_hash, ip, port, peer_id, client_type)
            VALUES (?, ?, ?, ?, ?)
        """;
        try (Connection conn = dataSource.getConnection();
             PreparedStatement stmt = conn.prepareStatement(sql)) {
            stmt.setString(1, infoHash);
            stmt.setString(2, ip);
            stmt.setInt(3, port);
            stmt.setString(4, peerId);
            stmt.setString(5, clientType);
            stmt.executeUpdate();
        } catch (SQLException e) {
            //logger.error("记录可疑客户端失败，info_hash={}, ip={}:{}", infoHash, ip, port, e);
        }
    }
    // 验证指定种子的上传总量与下载总量是否一致
    public void verifyFileTrafficConsistency(String infoHash) {
        String querySql = """
            SELECT 
                SUM(uploaded) AS total_upload, 
                SUM(downloaded) AS total_download,
                MIN(created_at) AS first_seen_time  -- 获取种子首次出现时间
            FROM peer_stats 
            WHERE info_hash = ?
        """;
        String insertAnomalySql = "INSERT INTO file_traffic_anomaly (info_hash, total_upload, total_download, create_time) VALUES (?, ?, ?, NOW())";

        try (Connection conn = dataSource.getConnection();
             PreparedStatement queryStmt = conn.prepareStatement(querySql);
             PreparedStatement anomalyStmt = conn.prepareStatement(insertAnomalySql)) {

            queryStmt.setString(1, infoHash);
            ResultSet rs = queryStmt.executeQuery();
            if (rs.next()) {
                long totalUpload = rs.getLong("total_upload");
                long totalDownload = rs.getLong("total_download");
                java.sql.Timestamp firstSeen = rs.getTimestamp("first_seen_time");

                // 忽略种子创建后1小时内的不平衡
                if (firstSeen != null && System.currentTimeMillis() - firstSeen.getTime() < 3600_000) {
                    return;
                }
                // 上传总量应等于下载总量（允许±1B误差避免计算精度问题）
                if (Math.abs(totalUpload - totalDownload) > 1) {
                    // logger.warn("检测到异常种子，info_hash={}，总上传={}，总下载={}", infoHash, totalUpload, totalDownload);

                    // 记录异常到数据库
                    anomalyStmt.setString(1, infoHash);
                    anomalyStmt.setLong(2, totalUpload);
                    anomalyStmt.setLong(3, totalDownload);
                    anomalyStmt.executeUpdate();
                }
            }
        } catch (SQLException e) {
            //logger.error("验证种子流量一致性失败，info_hash={}", infoHash, e);
        }
    }
}

