package com.pt5.pthouduan.ControllerTest;

import com.pt5.pthouduan.controller.RecommendController;
import com.pt5.pthouduan.entity.Torrent;
import com.pt5.pthouduan.service.RecommendService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.util.Arrays;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.anyLong;
import static org.mockito.Mockito.*;

class RecommendControllerTest {

    @Mock
    private RecommendService recommendService;

    @InjectMocks
    private RecommendController recommendController;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
    }

    @Test
    void getRecommendList_Success() {
        // 准备测试数据
        Torrent torrent1 = new Torrent();

        // 执行测试
        List<Torrent> actualList = recommendController.getRecommendList(123L);

        // 验证结果
        verify(recommendService, times(1)).recommendForUser(123L);
    }

    @Test
    void getRecommendList_EmptyList() {
        // 模拟空列表返回
        when(recommendService.recommendForUser(anyLong()))
                .thenReturn(List.of());

        List<Torrent> result = recommendController.getRecommendList(456L);

        assertTrue(result.isEmpty());
    }

    @Test
    void getRecommendList_InvalidUserId() {
        // 模拟无效用户ID情况
        when(recommendService.recommendForUser(-1L))
                .thenThrow(new IllegalArgumentException("Invalid user ID"));

        assertThrows(IllegalArgumentException.class, () -> {
            recommendController.getRecommendList(-1L);
        });
    }

    @Test
    void getRecommendList_ServiceException() {
        // 模拟服务层异常
        when(recommendService.recommendForUser(anyLong()))
                .thenThrow(new RuntimeException("Recommendation service unavailable"));

        assertThrows(RuntimeException.class, () -> {
            recommendController.getRecommendList(999L);
        });
    }
}
