package com.pt5.pthouduan.ControllerTest;

import com.pt5.pthouduan.controller.TorrentController;
import com.pt5.pthouduan.entity.Torrent;
import com.pt5.pthouduan.service.TorrentService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import static org.mockito.ArgumentMatchers.anyLong;
import static org.mockito.Mockito.*;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.get;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

class TorrentDetailControllerTest {

    @Mock
    private TorrentService torrentService;

    @InjectMocks
    private TorrentController torrentController;

    private MockMvc mockMvc;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(torrentController).build();
    }

    @Test
    void getTorrentById_ExistingId_ShouldReturnTorrent() throws Exception {
        // Arrange
        Long id = 1L;
        Torrent torrent = new Torrent();
        torrent.setTorrentid(id);

        when(torrentService.getTorrentById(id)).thenReturn(torrent);

        // Act & Assert
        mockMvc.perform(get("/torrent/{id}", id))
                .andExpect(status().isOk());
                //.andExpect(jsonPath("$.id").value(id));

        // 验证服务层方法被调用
        verify(torrentService, times(1)).getTorrentById(id);
    }

    @Test
    void getTorrentById_NonExistingId_ShouldReturnNotFound() throws Exception {
        // Arrange
        Long id = 999L;

        when(torrentService.getTorrentById(id)).thenReturn(null);

        // Act & Assert
        mockMvc.perform(get("/torrent/{id}", id))
                .andExpect(status().isNotFound());

        // 验证服务层方法被调用
        verify(torrentService, times(1)).getTorrentById(id);
    }

    @Test
    void getTorrentById_WhenServiceThrowsException_ShouldReturnBadRequest() throws Exception {
        // Arrange
        Long id = 1L;

        when(torrentService.getTorrentById(id)).thenThrow(new RuntimeException("Database error"));

        // Act & Assert
        mockMvc.perform(get("/torrent/{id}", id))
                .andExpect(status().isBadRequest());
                //.andExpect(jsonPath("$.message").value("获取种子详情失败: Database error"));

        // 验证服务层方法被调用
        verify(torrentService, times(1)).getTorrentById(id);
    }
}