package com.pt5.pthouduan.ControllerTest;

import com.pt5.pthouduan.controller.TorrentController;
import com.pt5.pthouduan.service.TorrentService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import static org.mockito.ArgumentMatchers.anyLong;
import static org.mockito.Mockito.*;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.post;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;

class TorrentSetPromotionControllerTest {

    @Mock
    private TorrentService torrentService;

    @InjectMocks
    private TorrentController torrentController;

    private MockMvc mockMvc;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(torrentController).build();
    }

    @Test
    void setPromotion_Success_ShouldReturnSuccess() throws Exception {
        // Arrange
        Long userid = 1L;
        Long torrentId = 101L;
        Long promotionId = 1L;

        // 模拟服务层调用成功
        doNothing().when(torrentService).setPromotion(torrentId, promotionId, userid);

        // Act & Assert
        mockMvc.perform(post("/torrent/setPromotion")
                        .param("userid", userid.toString())
                        .param("torrentId", torrentId.toString())
                        .param("promotionId", promotionId.toString()))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$.success").value(true))
                .andExpect(jsonPath("$.message").value("促销类型设置成功"));

        // 验证服务层方法被调用
        verify(torrentService, times(1)).setPromotion(torrentId, promotionId, userid);
    }

    @Test
    void setPromotion_SecurityException_ShouldReturnForbidden() throws Exception {
        // Arrange
        Long userid = 1L;
        Long torrentId = 101L;
        Long promotionId = 1L;

        // 模拟服务层抛出SecurityException
        doThrow(new SecurityException("无权设置促销")).when(torrentService).setPromotion(torrentId, promotionId, userid);

        // Act & Assert
        mockMvc.perform(post("/torrent/setPromotion")
                        .param("userid", userid.toString())
                        .param("torrentId", torrentId.toString())
                        .param("promotionId", promotionId.toString()))
                .andExpect(status().isForbidden())
                .andExpect(jsonPath("$.success").value(false))
                .andExpect(jsonPath("$.message").value("无权设置促销"));

        // 验证服务层方法被调用
        verify(torrentService, times(1)).setPromotion(torrentId, promotionId, userid);
    }

    @Test
    void setPromotion_OtherException_ShouldReturnInternalServerError() throws Exception {
        // Arrange
        Long userid = 1L;
        Long torrentId = 101L;
        Long promotionId = 1L;

        // 模拟服务层抛出其他异常
        doThrow(new RuntimeException("数据库错误")).when(torrentService).setPromotion(torrentId, promotionId, userid);

        // Act & Assert
        mockMvc.perform(post("/torrent/setPromotion")
                        .param("userid", userid.toString())
                        .param("torrentId", torrentId.toString())
                        .param("promotionId", promotionId.toString()))
                .andExpect(status().isInternalServerError())
                .andExpect(jsonPath("$.success").value(false))
                .andExpect(jsonPath("$.message").value("设置促销类型失败: 数据库错误"));

        // 验证服务层方法被调用
        verify(torrentService, times(1)).setPromotion(torrentId, promotionId, userid);
    }

    @Test
    void setPromotion_WithoutParameters_ShouldReturnBadRequest() throws Exception {
        // Act & Assert
        mockMvc.perform(post("/torrent/setPromotion"))
                .andExpect(status().isBadRequest());
    }
}