package com.pt5.pthouduan.ControllerTest;

import com.pt5.pthouduan.controller.UserController;
import com.pt5.pthouduan.entity.User;
import com.pt5.pthouduan.service.UserService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.ArgumentMatchers.*;
import static org.mockito.Mockito.*;

class UserControllerTest {

    @Mock
    private UserService userService;

    @InjectMocks
    private UserController userController;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
    }

    @Test
    void register_Success() {
        // 准备测试数据
        User user = new User(0L,"");
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", true);
        expectedResponse.put("message", "注册成功");

        // 模拟服务层行为
        when(userService.register(any(User.class), anyString(), anyString()))
                .thenReturn(expectedResponse);

        // 执行测试
        Map<String, Object> actualResponse = userController.register(user, "invite123", "email123");

        // 验证结果
        assertEquals(expectedResponse, actualResponse);
        verify(userService, times(1)).register(any(), anyString(), anyString());
    }

    @Test
    void login_Success() {
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", true);
        expectedResponse.put("token", "test-token");

        when(userService.login(anyString(), anyString()))
                .thenReturn(expectedResponse);

        Map<String, Object> actualResponse = userController.login("testuser", "password123");

        assertEquals(expectedResponse, actualResponse);
    }

//    @Test
//    void uploadAvatar_Success() throws IOException {
//        // 准备测试文件
//        MultipartFile file = new MockMultipartFile(
//                "avatar",
//                "test.jpg",
//                "image/jpeg",
//                "test image content".getBytes()
//        );
//
//        // 模拟服务层行为
//        //doNothing().when(userService).changeImage(anyString(), anyString());
//
//        // 执行测试
//        ResponseEntity<Map<String, Object>> response = userController.uploadAvatar(file);
//
//        // 验证结果
//        assertEquals(200, response.getStatusCodeValue());
//        assertTrue((Boolean) response.getBody().get("success"));
//        assertNotNull(response.getBody().get("url"));
//
//        // 验证文件是否保存到正确路径
////        Path expectedPath = Paths.get("../var/www/avatars/").resolve(anyString());
//        // 实际项目中需要添加文件存在性断言
//    }

//    @Test
//    void uploadAvatar_InvalidFileType() {
//        MultipartFile file = new MockMultipartFile(
//                "avatar",
//                "test.txt",
//                "text/plain",
//                "invalid content".getBytes()
//        );
//
//        ResponseEntity<Map<String, Object>> response = userController.uploadAvatar(file);
//
//        assertEquals(400, response.getStatusCodeValue());
//        assertEquals("只支持JPG/PNG/GIF格式的图片", response.getBody().get("message"));
//    }

    @Test
    void changeImage_Success() {
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", true);
        expectedResponse.put("message", "头像更改成功");

        // 执行测试
        Map<String, Object> actualResponse = userController.changeimage("testuser", "new-avatar.jpg");

        // 验证结果
        assertEquals(expectedResponse, actualResponse);
        verify(userService, times(1)).changeImage("testuser", "new-avatar.jpg");
    }

    @Test
    void changePassword_Success() {
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("success", true);

        when(userService.changePassword(anyString(), anyString(), anyString()))
                .thenReturn(expectedResponse);

        Map<String, Object> actualResponse = userController.changePassword(
                "testuser", "oldPass", "newPass");

        assertEquals(expectedResponse, actualResponse);
    }

    // 其他方法测试示例
    @Test
    void getUserInfo_Success() {
        Map<String, Object> expectedResponse = new HashMap<>();
        expectedResponse.put("username", "testuser");

        when(userService.UserInfo(anyString()))
                .thenReturn(expectedResponse);

        Map<String, Object> actualResponse = userController.getuser("testuser");

        assertEquals(expectedResponse, actualResponse);
    }
}