package com.pt5.pthouduan.controller;

import com.pt5.pthouduan.entity.request_resources;
import com.pt5.pthouduan.service.RequestResourcesService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import java.time.LocalDateTime;
import java.util.List;

import static org.junit.jupiter.api.Assertions.*;
import static org.mockito.Mockito.*;

class RequestResourcesControllerTest {

    @Mock
    private RequestResourcesService requestResourcesService;

    @InjectMocks
    private RequestResourcesController requestResourcesController;

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks(this);
    }

    @Test
    void updateMoney_ShouldReturnTrue_WhenSuccess() {
        when(requestResourcesService.updateMoney(1, 100)).thenReturn(true);

        boolean result = requestResourcesController.updateMoney(1, 100);

        assertTrue(result);
        verify(requestResourcesService).updateMoney(1, 100);
    }

    @Test
    void deleteRequest_ShouldReturnTrue_WhenSuccess() {
        when(requestResourcesService.deleteRequest(1)).thenReturn(true);

        boolean result = requestResourcesController.deleteRequest(1);

        assertTrue(result);
        verify(requestResourcesService).deleteRequest(1);
    }

    @Test
    void findByName_ShouldReturnMatchingRequests() {
        request_resources req = new request_resources();
        req.setName("Urgent Help");

        when(requestResourcesService.findByName("Urgent Help")).thenReturn(List.of(req));

        List<request_resources> result = requestResourcesController.findByName("Urgent Help");

        assertEquals(1, result.size());
        assertEquals("Urgent Help", result.get(0).getName());
    }

    @Test
    void findByUserid_ShouldReturnUserRequests() {
        request_resources req = new request_resources();
        req.setUserid(123L);

        when(requestResourcesService.findByUserid(123L)).thenReturn(List.of(req));

        List<request_resources> result = requestResourcesController.findByUserid(123L);

        assertEquals(1, result.size());
        assertEquals(123L, result.get(0).getUserid());
    }

    @Test
    void getTotalMoneyByName_ShouldReturnCorrectSum() {
        when(requestResourcesService.calculateTotalMoneyByName("Education")).thenReturn(500);

        int total = requestResourcesController.getTotalMoneyByName("Education");

        assertEquals(500, total);
    }

    @Test
    void findByLoaduser_ShouldReturnLoaduserRequests() {
        request_resources req = new request_resources();
        req.setLoaduser(456L);

        when(requestResourcesService.findByLoaduser(456L)).thenReturn(List.of(req));

        List<request_resources> result = requestResourcesController.findByLoaduser(456L);

        assertEquals(1, result.size());
        assertEquals(456L, result.get(0).getLoaduser());
    }

    @Test
    void updateLoaduserByName_ShouldReturnTrue_WhenSuccess() {
        when(requestResourcesService.updateLoaduserByName("Medical", 789L)).thenReturn(true);

        boolean result = requestResourcesController.updateLoaduserByName("Medical", 789L);

        assertTrue(result);
    }

    @Test
    void updateTorrentid_ShouldReturnTrue_WhenSuccess() {
        when(requestResourcesService.updateTorrentid(1, 999L)).thenReturn(true);

        boolean result = requestResourcesController.updateTorrentid(1, 999L);

        assertTrue(result);
    }

    @Test
    void getTorrentid_ShouldReturnCorrectValue() {
        request_resources req = new request_resources();
        req.setTorrentid(888L);

        when(requestResourcesService.findByRequestid(1)).thenReturn(req);

        Long result = requestResourcesController.getTorrentid(1);

        assertEquals(888L, result);
    }

    @Test
    void getInfoByRequestId_ShouldReturnInfoMap() {
        request_resources req = new request_resources();
        req.setMoney(200);
        req.setLoaduser(101L);
        req.setTorrentid(555L);

        when(requestResourcesService.findByRequestid(1)).thenReturn(req);

        var result = requestResourcesController.getInfoByRequestId(1);

        assertEquals(200, result.get("money"));
        assertEquals(101L, result.get("loaduser"));
        assertEquals(555L, result.get("torrentid"));
    }

    @Test
    void getAllRequests_ShouldReturnAllRequests() {
        request_resources r1 = new request_resources();
        r1.setRequestid(1);
        request_resources r2 = new request_resources();
        r2.setRequestid(2);

        when(requestResourcesService.getAllRequests()).thenReturn(List.of(r1, r2));

        List<request_resources> result = requestResourcesController.getAllRequests();

        assertEquals(2, result.size());
    }
}
